/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import java.util.Objects;
import org.jruby.Ruby;
import org.jruby.ast.LiteralValue;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.SideEffectFree;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.ir.builder.StringStyle;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.StringSupport;

public class StrNode
extends Node
implements ILiteralNode,
LiteralValue,
SideEffectFree {
    private final ByteList value;
    private final int codeRange;
    private StringStyle stringStyle;

    public StrNode(int line, ByteList value2) {
        this(line, value2, StringSupport.codeRangeScan(value2.getEncoding(), value2), StringStyle.Frozen);
    }

    public StrNode(int line, ByteList value2, int codeRange, StringStyle stringStyle) {
        super(line, false);
        this.value = value2;
        this.codeRange = codeRange;
        this.stringStyle = stringStyle;
    }

    public StrNode(int line, StrNode head, StrNode tail) {
        super(line, false);
        ByteList headBL = head.getValue();
        ByteList tailBL = tail.getValue();
        ByteList myValue = new ByteList(headBL.getRealSize() + tailBL.getRealSize());
        myValue.setEncoding(headBL.getEncoding());
        myValue.append(headBL);
        myValue.append(tailBL);
        this.stringStyle = head.stringStyle != tail.stringStyle ? (head.stringStyle == StringStyle.Frozen ? tail.stringStyle : (tail.stringStyle == StringStyle.Frozen ? head.stringStyle : StringStyle.Chilled)) : head.stringStyle;
        this.value = myValue;
        this.codeRange = StringSupport.codeRangeScan(this.value.getEncoding(), this.value);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.STRNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitStrNode(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StrNode strNode = (StrNode)o;
        return this.value.equals(strNode.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public ByteList getValue() {
        return this.value;
    }

    public int getCodeRange() {
        return this.codeRange;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public StringStyle getStringStyle() {
        return this.stringStyle;
    }

    public void setStringStyle(StringStyle stringStyle) {
        this.stringStyle = stringStyle;
    }

    @Override
    public IRubyObject literalValue(Ruby runtime2) {
        return runtime2.newString(this.value);
    }
}

