/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.DTLSHandshakeRetransmit;
import org.bouncycastle.tls.DTLSReassembler;
import org.bouncycastle.tls.DTLSRecordLayer;
import org.bouncycastle.tls.DTLSRequest;
import org.bouncycastle.tls.DatagramSender;
import org.bouncycastle.tls.DeferredHash;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.Timeout;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsHandshakeHash;
import org.bouncycastle.tls.TlsTimeoutException;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Integers;

class DTLSReliableHandshake {
    static final int MESSAGE_HEADER_LENGTH = 12;
    private static final int MAX_RECEIVE_AHEAD = 16;
    private static final int MAX_RESEND_MILLIS = 60000;
    private DTLSRecordLayer recordLayer;
    private Timeout handshakeTimeout;
    private TlsHandshakeHash handshakeHash;
    private Hashtable currentInboundFlight = new Hashtable();
    private Hashtable previousInboundFlight = null;
    private Vector outboundFlight = new Vector();
    private int initialResendMillis;
    private int resendMillis = -1;
    private Timeout resendTimeout = null;
    private int next_send_seq = 0;
    private int next_receive_seq = 0;

    static ByteArrayInputStream receiveClientHelloMessage(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 12) {
            return null;
        }
        short s = TlsUtils.readUint8(byArray, n);
        if (1 != s) {
            return null;
        }
        int n3 = TlsUtils.readUint24(byArray, n + 1);
        if (n2 != 12 + n3) {
            return null;
        }
        int n4 = TlsUtils.readUint24(byArray, n + 6);
        if (0 != n4) {
            return null;
        }
        int n5 = TlsUtils.readUint24(byArray, n + 9);
        if (n3 != n5) {
            return null;
        }
        return new ByteArrayInputStream(byArray, n + 12, n3);
    }

    static void sendHelloVerifyRequest(DatagramSender datagramSender, long l, byte[] byArray) throws IOException {
        TlsUtils.checkUint8(byArray.length);
        int n = 3 + byArray.length;
        byte[] byArray2 = new byte[12 + n];
        TlsUtils.writeUint8((short)3, byArray2, 0);
        TlsUtils.writeUint24(n, byArray2, 1);
        TlsUtils.writeUint24(n, byArray2, 9);
        TlsUtils.writeVersion(ProtocolVersion.DTLSv10, byArray2, 12);
        TlsUtils.writeOpaque8(byArray, byArray2, 14);
        DTLSRecordLayer.sendHelloVerifyRequestRecord(datagramSender, l, byArray2);
    }

    DTLSReliableHandshake(TlsContext tlsContext, DTLSRecordLayer dTLSRecordLayer, int n, int n2, DTLSRequest dTLSRequest) {
        this.recordLayer = dTLSRecordLayer;
        this.handshakeHash = new DeferredHash(tlsContext);
        this.handshakeTimeout = Timeout.forWaitMillis(n);
        this.initialResendMillis = n2;
        if (null != dTLSRequest) {
            this.resendMillis = n2;
            this.resendTimeout = new Timeout(this.resendMillis);
            long l = dTLSRequest.getRecordSeq();
            int n3 = dTLSRequest.getMessageSeq();
            byte[] byArray = dTLSRequest.getMessage();
            this.recordLayer.resetAfterHelloVerifyRequestServer(l);
            DTLSReassembler dTLSReassembler = new DTLSReassembler(1, byArray.length - 12);
            this.currentInboundFlight.put(Integers.valueOf((int)n3), dTLSReassembler);
            this.next_send_seq = 1;
            this.next_receive_seq = n3 + 1;
            this.handshakeHash.update(byArray, 0, byArray.length);
        }
    }

    void resetAfterHelloVerifyRequestClient() {
        this.currentInboundFlight = new Hashtable();
        this.previousInboundFlight = null;
        this.outboundFlight = new Vector();
        this.resendMillis = -1;
        this.resendTimeout = null;
        this.next_receive_seq = 1;
        this.handshakeHash.reset();
    }

    TlsHandshakeHash getHandshakeHash() {
        return this.handshakeHash;
    }

    void prepareToFinish() {
        this.handshakeHash.stopTracking();
    }

    void sendMessage(short s, byte[] byArray) throws IOException {
        TlsUtils.checkUint24(byArray.length);
        if (null != this.resendTimeout) {
            this.checkInboundFlight();
            this.resendMillis = -1;
            this.resendTimeout = null;
            this.outboundFlight.removeAllElements();
        }
        Message message = new Message(this.next_send_seq++, s, byArray);
        this.outboundFlight.addElement(message);
        this.writeMessage(message);
        this.updateHandshakeMessagesDigest(message);
    }

    Message receiveMessage() throws IOException {
        Message message = this.implReceiveMessage();
        this.updateHandshakeMessagesDigest(message);
        return message;
    }

    byte[] receiveMessageBody(short s) throws IOException {
        Message message = this.implReceiveMessage();
        if (message.getType() != s) {
            throw new TlsFatalAlert(10);
        }
        this.updateHandshakeMessagesDigest(message);
        return message.getBody();
    }

    Message receiveMessageDelayedDigest(short s) throws IOException {
        Message message = this.implReceiveMessage();
        if (message.getType() != s) {
            throw new TlsFatalAlert(10);
        }
        return message;
    }

    void updateHandshakeMessagesDigest(Message message) throws IOException {
        short s = message.getType();
        switch (s) {
            case 0: 
            case 3: 
            case 24: {
                break;
            }
            default: {
                byte[] byArray = message.getBody();
                byte[] byArray2 = new byte[12];
                TlsUtils.writeUint8(s, byArray2, 0);
                TlsUtils.writeUint24(byArray.length, byArray2, 1);
                TlsUtils.writeUint16(message.getSeq(), byArray2, 4);
                TlsUtils.writeUint24(0, byArray2, 6);
                TlsUtils.writeUint24(byArray.length, byArray2, 9);
                this.handshakeHash.update(byArray2, 0, byArray2.length);
                this.handshakeHash.update(byArray, 0, byArray.length);
            }
        }
    }

    void finish() {
        DTLSHandshakeRetransmit dTLSHandshakeRetransmit = null;
        if (null != this.resendTimeout) {
            this.checkInboundFlight();
        } else {
            this.prepareInboundFlight(null);
            if (this.previousInboundFlight != null) {
                dTLSHandshakeRetransmit = new DTLSHandshakeRetransmit(){

                    @Override
                    public void receivedHandshakeRecord(int n, byte[] byArray, int n2, int n3) throws IOException {
                        DTLSReliableHandshake.this.processRecord(0, n, byArray, n2, n3);
                    }
                };
            }
        }
        this.recordLayer.handshakeSuccessful(dTLSHandshakeRetransmit);
    }

    static int backOff(int n) {
        return Math.min(n * 2, 60000);
    }

    private void checkInboundFlight() {
        Enumeration enumeration = this.currentInboundFlight.keys();
        while (enumeration.hasMoreElements()) {
            Integer n = (Integer)enumeration.nextElement();
            if (n < this.next_receive_seq) continue;
        }
    }

    private Message getPendingMessage() throws IOException {
        byte[] byArray;
        DTLSReassembler dTLSReassembler = (DTLSReassembler)this.currentInboundFlight.get(Integers.valueOf((int)this.next_receive_seq));
        if (dTLSReassembler != null && (byArray = dTLSReassembler.getBodyIfComplete()) != null) {
            this.previousInboundFlight = null;
            return new Message(this.next_receive_seq++, dTLSReassembler.getMsgType(), byArray);
        }
        return null;
    }

    private Message implReceiveMessage() throws IOException {
        long l = System.currentTimeMillis();
        if (null == this.resendTimeout) {
            this.resendMillis = this.initialResendMillis;
            this.resendTimeout = new Timeout(this.resendMillis, l);
            this.prepareInboundFlight(new Hashtable());
        }
        byte[] byArray = null;
        while (true) {
            int n;
            if (this.recordLayer.isClosed()) {
                throw new TlsFatalAlert(90);
            }
            Message message = this.getPendingMessage();
            if (message != null) {
                return message;
            }
            if (Timeout.hasExpired(this.handshakeTimeout, l)) {
                throw new TlsTimeoutException("Handshake timed out");
            }
            int n2 = Timeout.getWaitMillis(this.handshakeTimeout, l);
            if ((n2 = Timeout.constrainWaitMillis(n2, this.resendTimeout, l)) < 1) {
                n2 = 1;
            }
            int n3 = this.recordLayer.getReceiveLimit();
            if (byArray == null || byArray.length < n3) {
                byArray = new byte[n3];
            }
            if ((n = this.recordLayer.receive(byArray, 0, n3, n2)) < 0) {
                this.resendOutboundFlight();
            } else {
                this.processRecord(16, this.recordLayer.getReadEpoch(), byArray, 0, n);
            }
            l = System.currentTimeMillis();
        }
    }

    private void prepareInboundFlight(Hashtable hashtable) {
        DTLSReliableHandshake.resetAll(this.currentInboundFlight);
        this.previousInboundFlight = this.currentInboundFlight;
        this.currentInboundFlight = hashtable;
    }

    private void processRecord(int n, int n2, byte[] byArray, int n3, int n4) throws IOException {
        int n5;
        int n6;
        boolean bl = false;
        while (n4 >= 12 && n4 >= (n6 = (n5 = TlsUtils.readUint24(byArray, n3 + 9)) + 12)) {
            int n7;
            int n8 = TlsUtils.readUint24(byArray, n3 + 1);
            int n9 = TlsUtils.readUint24(byArray, n3 + 6);
            if (n9 + n5 > n8) break;
            short s = TlsUtils.readUint8(byArray, n3 + 0);
            int n10 = n7 = s == 20 ? 1 : 0;
            if (n2 != n7) break;
            int n11 = TlsUtils.readUint16(byArray, n3 + 4);
            if (n11 < this.next_receive_seq + n) {
                DTLSReassembler dTLSReassembler;
                if (n11 >= this.next_receive_seq) {
                    dTLSReassembler = (DTLSReassembler)this.currentInboundFlight.get(Integers.valueOf((int)n11));
                    if (dTLSReassembler == null) {
                        dTLSReassembler = new DTLSReassembler(s, n8);
                        this.currentInboundFlight.put(Integers.valueOf((int)n11), dTLSReassembler);
                    }
                    dTLSReassembler.contributeFragment(s, n8, byArray, n3 + 12, n9, n5);
                } else if (this.previousInboundFlight != null && (dTLSReassembler = (DTLSReassembler)this.previousInboundFlight.get(Integers.valueOf((int)n11))) != null) {
                    dTLSReassembler.contributeFragment(s, n8, byArray, n3 + 12, n9, n5);
                    bl = true;
                }
            }
            n3 += n6;
            n4 -= n6;
        }
        if (bl && DTLSReliableHandshake.checkAll(this.previousInboundFlight)) {
            this.resendOutboundFlight();
            DTLSReliableHandshake.resetAll(this.previousInboundFlight);
        }
    }

    private void resendOutboundFlight() throws IOException {
        this.recordLayer.resetWriteEpoch();
        for (int i = 0; i < this.outboundFlight.size(); ++i) {
            this.writeMessage((Message)this.outboundFlight.elementAt(i));
        }
        this.resendMillis = DTLSReliableHandshake.backOff(this.resendMillis);
        this.resendTimeout = new Timeout(this.resendMillis);
    }

    private void writeMessage(Message message) throws IOException {
        int n;
        int n2 = this.recordLayer.getSendLimit();
        int n3 = n2 - 12;
        if (n3 < 1) {
            throw new TlsFatalAlert(80);
        }
        int n4 = message.getBody().length;
        int n5 = 0;
        do {
            n = Math.min(n4 - n5, n3);
            this.writeHandshakeFragment(message, n5, n);
        } while ((n5 += n) < n4);
    }

    private void writeHandshakeFragment(Message message, int n, int n2) throws IOException {
        RecordLayerBuffer recordLayerBuffer = new RecordLayerBuffer(12 + n2);
        TlsUtils.writeUint8(message.getType(), (OutputStream)recordLayerBuffer);
        TlsUtils.writeUint24(message.getBody().length, recordLayerBuffer);
        TlsUtils.writeUint16(message.getSeq(), recordLayerBuffer);
        TlsUtils.writeUint24(n, recordLayerBuffer);
        TlsUtils.writeUint24(n2, recordLayerBuffer);
        recordLayerBuffer.write(message.getBody(), n, n2);
        recordLayerBuffer.sendToRecordLayer(this.recordLayer);
    }

    private static boolean checkAll(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            if (((DTLSReassembler)enumeration.nextElement()).getBodyIfComplete() != null) continue;
            return false;
        }
        return true;
    }

    private static void resetAll(Hashtable hashtable) {
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            ((DTLSReassembler)enumeration.nextElement()).reset();
        }
    }

    static class Message {
        private final int message_seq;
        private final short msg_type;
        private final byte[] body;

        private Message(int n, short s, byte[] byArray) {
            this.message_seq = n;
            this.msg_type = s;
            this.body = byArray;
        }

        public int getSeq() {
            return this.message_seq;
        }

        public short getType() {
            return this.msg_type;
        }

        public byte[] getBody() {
            return this.body;
        }
    }

    static class RecordLayerBuffer
    extends ByteArrayOutputStream {
        RecordLayerBuffer(int n) {
            super(n);
        }

        void sendToRecordLayer(DTLSRecordLayer dTLSRecordLayer) throws IOException {
            dTLSRecordLayer.send(this.buf, 0, this.count);
            this.buf = null;
        }
    }
}

