/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetLabel;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.tools.GBC;

public class PresetLink
extends TaggingPresetItem {
    public String preset_name = "";

    @Override
    public boolean addToPanel(JPanel p, Collection<OsmPrimitive> sel, boolean presetInitiallyMatches) {
        String presetName = this.preset_name;
        Optional<TaggingPreset> found = TaggingPresets.getTaggingPresets().stream().filter(preset -> presetName.equals(preset.name)).findFirst();
        if (found.isPresent()) {
            TaggingPreset t = found.get();
            TaggingPresetLabel lbl = new TaggingPresetLabel(t);
            lbl.addMouseListener(new TaggingPresetMouseAdapter(t));
            p.add((Component)lbl, GBC.eol().fill(2));
        }
        return false;
    }

    @Override
    public void addCommands(List<Tag> changedTags) {
    }

    public String toString() {
        return "PresetLink [preset_name=" + this.preset_name + ']';
    }

    static final class TaggingPresetMouseAdapter
    extends MouseAdapter {
        private final TaggingPreset t;

        TaggingPresetMouseAdapter(TaggingPreset t) {
            this.t = t;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.t.actionPerformed(null);
        }
    }
}

