/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.dialogs.changeset.query.AdvancedChangesetQueryPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.query.BasicChangesetQueryPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.query.UrlBasedQueryPanel;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;
import org.openstreetmap.josm.tools.Logging;

public class ChangesetQueryDialog
extends JDialog {
    private JTabbedPane tpQueryPanels;
    private final BasicChangesetQueryPanel pnlBasicChangesetQueries = new BasicChangesetQueryPanel();
    private final UrlBasedQueryPanel pnlUrlBasedQueries = new UrlBasedQueryPanel();
    private final AdvancedChangesetQueryPanel pnlAdvancedQueries = new AdvancedChangesetQueryPanel();
    private boolean canceled;

    public ChangesetQueryDialog(Window parent) {
        super(parent, Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    protected JPanel buildContentPanel() {
        this.tpQueryPanels = new JTabbedPane();
        this.tpQueryPanels.add(this.pnlBasicChangesetQueries);
        this.tpQueryPanels.add(this.pnlUrlBasedQueries);
        this.tpQueryPanels.add(this.pnlAdvancedQueries);
        this.tpQueryPanels.setTitleAt(0, I18n.tr("Basic", new Object[0]));
        this.tpQueryPanels.setToolTipTextAt(0, I18n.tr("Download changesets using predefined queries", new Object[0]));
        this.tpQueryPanels.setTitleAt(1, I18n.tr("From URL", new Object[0]));
        this.tpQueryPanels.setToolTipTextAt(1, I18n.tr("Query changesets from a server URL", new Object[0]));
        this.tpQueryPanels.setTitleAt(2, I18n.tr("Advanced", new Object[0]));
        this.tpQueryPanels.setToolTipTextAt(2, I18n.tr("Use a custom changeset query", new Object[0]));
        JPanel pnl = new JPanel(new BorderLayout());
        pnl.add((Component)this.tpQueryPanels, "Center");
        return pnl;
    }

    protected JPanel buildButtonPanel() {
        JPanel pnl = new JPanel(new FlowLayout(1));
        JButton queryButton = new JButton(new QueryAction());
        queryButton.setName("queryButton");
        pnl.add(queryButton);
        JButton cancelButton = new JButton(new CancelAction());
        cancelButton.setName("cancelButton");
        pnl.add(cancelButton);
        pnl.add(new JButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/ChangesetQuery"))));
        return pnl;
    }

    protected final void build() {
        this.setTitle(I18n.tr("Query changesets", new Object[0]));
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)this.buildContentPanel(), "Center");
        cp.add((Component)this.buildButtonPanel(), "South");
        InputMapUtils.addEscapeAction(this.getRootPane(), new CancelAction());
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/ChangesetQueryDialog"));
        this.addWindowListener(new WindowEventHandler());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void initForUserInput() {
        this.pnlBasicChangesetQueries.init();
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public ChangesetQuery getChangesetQuery() {
        if (this.isCanceled()) {
            return null;
        }
        switch (this.tpQueryPanels.getSelectedIndex()) {
            case 0: {
                return this.pnlBasicChangesetQueries.buildChangesetQuery();
            }
            case 1: {
                return this.pnlUrlBasedQueries.buildChangesetQuery();
            }
            case 2: {
                return this.pnlAdvancedQueries.buildChangesetQuery();
            }
        }
        return null;
    }

    public void startUserInput() {
        this.pnlUrlBasedQueries.startUserInput();
        this.pnlAdvancedQueries.startUserInput();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), new Dimension(400, 400))).applySafe(this);
            this.setCanceled(false);
            this.startUserInput();
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
            this.pnlAdvancedQueries.rememberSettings();
        }
        super.setVisible(visible);
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent arg0) {
            new CancelAction().cancel();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Close the dialog and abort querying of changesets", new Object[0]));
        }

        public void cancel() {
            ChangesetQueryDialog.this.setCanceled(true);
            ChangesetQueryDialog.this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            this.cancel();
        }
    }

    class QueryAction
    extends AbstractAction {
        QueryAction() {
            this.putValue("Name", I18n.tr("Query", new Object[0]));
            new ImageProvider("dialogs", "search").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Query and download changesets", new Object[0]));
        }

        protected void alertInvalidChangesetQuery() {
            HelpAwareOptionPane.showOptionDialog(ChangesetQueryDialog.this, I18n.tr("Please enter a valid changeset query URL first.", new Object[0]), I18n.tr("Illegal changeset query URL", new Object[0]), 2, HelpUtil.ht("/Dialog/ChangesetQueryDialog#EnterAValidChangesetQueryUrlFirst"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            try {
                switch (ChangesetQueryDialog.this.tpQueryPanels.getSelectedIndex()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        if (ChangesetQueryDialog.this.getChangesetQuery() != null) break;
                        this.alertInvalidChangesetQuery();
                        ChangesetQueryDialog.this.pnlUrlBasedQueries.startUserInput();
                        return;
                    }
                    case 2: {
                        if (ChangesetQueryDialog.this.getChangesetQuery() != null) break;
                        ChangesetQueryDialog.this.pnlAdvancedQueries.displayMessageIfInvalid();
                        return;
                    }
                }
                ChangesetQueryDialog.this.setCanceled(false);
                ChangesetQueryDialog.this.setVisible(false);
            }
            catch (IllegalStateException e) {
                Logging.error(e);
                JOptionPane.showMessageDialog(ChangesetQueryDialog.this, e.getMessage(), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }
}

