/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;

public abstract class CachedProperty<T>
extends AbstractProperty<T>
implements PreferenceChangedListener {
    private final String defaultValueAsString;
    private T value;
    private int updateCount;

    protected CachedProperty(String key, String defaultValueAsString) {
        super(key, null);
        Config.getPref().addKeyPreferenceChangeListener(key, this);
        this.defaultValueAsString = defaultValueAsString;
        this.updateValue();
    }

    protected final void updateValue() {
        this.value = !Config.getPref().get(this.key).isEmpty() ? this.fromString(Config.getPref().get(this.key)) : this.getDefaultValue();
        ++this.updateCount;
    }

    protected abstract T fromString(String var1);

    @Override
    public T get() {
        return this.value;
    }

    public void put(String value) {
        Config.getPref().put(this.key, value);
        this.value = this.fromString(value);
        ++this.updateCount;
    }

    @Override
    public final boolean put(T value) {
        throw new UnsupportedOperationException("You cannot use put(T). Use put(String) instead.");
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public T getDefaultValue() {
        return this.fromString(this.getDefaultValueAsString());
    }

    public String getDefaultValueAsString() {
        return this.defaultValueAsString;
    }

    public String getAsString() {
        return this.getPreferences().get(this.getKey(), this.getDefaultValueAsString());
    }

    @Override
    public void preferenceChanged(PreferenceChangeEvent e) {
        if (e.getKey().equals(this.key)) {
            this.updateValue();
        }
    }
}

