/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.pcap4j.core.PcapAddress;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.core.Pcaps;
import org.pcap4j.util.LinkLayerAddress;

public class NifSelector {
    private static String LINE_SEPARATOR = System.getProperty("line.separator");

    public final PcapNetworkInterface selectNetworkInterface() throws IOException {
        List<PcapNetworkInterface> allDevs = null;
        try {
            allDevs = Pcaps.findAllDevs();
        }
        catch (PcapNativeException e) {
            throw new IOException(e.getMessage());
        }
        if (allDevs == null || allDevs.isEmpty()) {
            throw new IOException("No NIF to capture.");
        }
        this.showNifList(allDevs);
        return this.doSelect(allDevs);
    }

    protected void write(String msg) throws IOException {
        System.out.print(msg);
    }

    protected String read() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        return reader.readLine();
    }

    protected void showNifList(List<PcapNetworkInterface> nifs) throws IOException {
        StringBuilder sb = new StringBuilder(200);
        int nifIdx = 0;
        for (PcapNetworkInterface nif : nifs) {
            sb.append("NIF[").append(nifIdx).append("]: ").append(nif.getName()).append(LINE_SEPARATOR);
            if (nif.getDescription() != null) {
                sb.append("      : description: ").append(nif.getDescription()).append(LINE_SEPARATOR);
            }
            for (LinkLayerAddress linkLayerAddress : nif.getLinkLayerAddresses()) {
                sb.append("      : link layer address: ").append(linkLayerAddress).append(LINE_SEPARATOR);
            }
            for (PcapAddress pcapAddress : nif.getAddresses()) {
                sb.append("      : address: ").append(pcapAddress.getAddress()).append(LINE_SEPARATOR);
            }
            ++nifIdx;
        }
        sb.append(LINE_SEPARATOR);
        this.write(sb.toString());
    }

    protected PcapNetworkInterface doSelect(List<PcapNetworkInterface> nifs) throws IOException {
        int nifIdx;
        while (true) {
            this.write("Select a device number to capture packets, or enter 'q' to quit > ");
            String input = this.read();
            if (input == null) continue;
            if (input.equals("q")) {
                return null;
            }
            try {
                nifIdx = Integer.parseInt(input);
                if (nifIdx >= 0 && nifIdx < nifs.size()) break;
                this.write("Invalid input." + LINE_SEPARATOR);
            }
            catch (NumberFormatException e) {
                this.write("Invalid input." + LINE_SEPARATOR);
            }
        }
        return nifs.get(nifIdx);
    }
}

