/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IcmpIdentifiablePacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.NotApplicable;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6EchoReplyPacket
extends IcmpIdentifiablePacket {
    private static final long serialVersionUID = -3713149118572340972L;
    private final IcmpV6EchoReplyHeader header;
    private final Packet payload;

    public static IcmpV6EchoReplyPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IcmpV6EchoReplyPacket(rawData, offset, length);
    }

    private IcmpV6EchoReplyPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new IcmpV6EchoReplyHeader(rawData, offset, length);
        int payloadLength = length - this.header.length();
        this.payload = payloadLength > 0 ? PacketFactories.getFactory(Packet.class, NotApplicable.class).newInstance(rawData, offset + this.header.length(), payloadLength, NotApplicable.UNKNOWN) : null;
    }

    private IcmpV6EchoReplyPacket(Builder builder2) {
        super(builder2);
        this.payload = builder2.payloadBuilder != null ? builder2.payloadBuilder.build() : null;
        this.header = new IcmpV6EchoReplyHeader(builder2);
    }

    @Override
    public IcmpV6EchoReplyHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV6EchoReplyHeader
    extends IcmpIdentifiablePacket.IcmpIdentifiableHeader {
        private static final long serialVersionUID = -5140524898291969262L;

        private IcmpV6EchoReplyHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            super(rawData, offset, length);
        }

        private IcmpV6EchoReplyHeader(Builder builder2) {
            super(builder2);
        }

        @Override
        protected String getHeaderName() {
            return "ICMPv6 Echo Reply Header";
        }
    }

    public static final class Builder
    extends IcmpIdentifiablePacket.Builder {
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        private Builder(IcmpV6EchoReplyPacket packet) {
            super(packet);
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        @Override
        public Builder identifier(short identifier) {
            super.identifier(identifier);
            return this;
        }

        @Override
        public Builder sequenceNumber(short sequenceNumber) {
            super.sequenceNumber(sequenceNumber);
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        @Override
        public IcmpV6EchoReplyPacket build() {
            return new IcmpV6EchoReplyPacket(this);
        }
    }
}

