/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import org.jivesoftware.smack.filter.AbstractJidTypeFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jxmpp.jid.Jid;

public abstract class AbstractPossibleJidTypeFilter
extends AbstractJidTypeFilter {
    protected AbstractPossibleJidTypeFilter(AbstractJidTypeFilter.JidType jidType) {
        super(jidType);
    }

    @Override
    public final boolean accept(Stanza stanza) {
        Jid jid = this.getJidToInspect(stanza);
        if (jid == null) {
            return false;
        }
        switch (this.jidType) {
            case entityFull: {
                return null != jid.asEntityFullJidIfPossible();
            }
            case entityBare: {
                return null != jid.asEntityBareJidIfPossible();
            }
            case domainFull: {
                return null != jid.asDomainFullJidIfPossible();
            }
            case domainBare: 
            case any: {
                return true;
            }
        }
        throw new AssertionError();
    }
}

