/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.condesc;

import java.util.HashSet;
import java.util.Set;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.condesc.TransportExtension;

public class ConferenceDescriptionExtension
extends AbstractPacketExtension {
    public static final String NAMESPACE = "http://jitsi.org/protocol/condesc";
    public static final String ELEMENT = "conference";
    public static final String URI_ATTR_NAME = "uri";
    public static final String PASSWORD_ATTR_NAME = "auth";
    public static final String CALLID_ATTR_NAME = "callid";
    public static final String AVAILABLE_ATTR_NAME = "available";
    public static final String CONFERENCE_NAME_ATTR_NAME = "conference_name";

    public ConferenceDescriptionExtension() {
        this(null, null, null);
    }

    public ConferenceDescriptionExtension(String uri) {
        this(uri, null, null);
    }

    public ConferenceDescriptionExtension(String uri, String callId) {
        this(uri, callId, null);
    }

    public ConferenceDescriptionExtension(String uri, String callId, String password) {
        super(NAMESPACE, ELEMENT);
        if (uri != null) {
            this.setUri(uri);
        }
        if (callId != null) {
            this.setCallId(callId);
        }
        if (password != null) {
            this.setAuth(password);
        }
    }

    public ConferenceDescriptionExtension(String uri, String callId, String password, boolean available, String displayName, Set<String> transports) {
        this(uri, callId, password);
        this.setAvailable(available);
        if (displayName != null) {
            this.setName(displayName);
        }
        for (String transport : transports) {
            this.addChildExtension(new TransportExtension(transport));
        }
    }

    public String getUri() {
        return this.getAttributeAsString(URI_ATTR_NAME);
    }

    public String getCallId() {
        return this.getAttributeAsString(CALLID_ATTR_NAME);
    }

    public String getPassword() {
        return this.getAttributeAsString(PASSWORD_ATTR_NAME);
    }

    public void setUri(String uri) {
        this.setAttribute(URI_ATTR_NAME, uri);
    }

    public void setCallId(String callId) {
        this.setAttribute(CALLID_ATTR_NAME, callId);
    }

    public void setAuth(String password) {
        this.setAttribute(PASSWORD_ATTR_NAME, password);
    }

    public void setAvailable(boolean available) {
        this.setAttribute(AVAILABLE_ATTR_NAME, available);
    }

    public void setName(String name) {
        this.setAttribute(CONFERENCE_NAME_ATTR_NAME, name);
    }

    public boolean isAvailable() {
        return Boolean.parseBoolean(this.getAttributeAsString(AVAILABLE_ATTR_NAME));
    }

    public void addTransport(String transport) {
        this.addChildExtension(new TransportExtension(transport));
    }

    public Set<String> getTransports() {
        HashSet<String> transports = new HashSet<String>();
        for (TransportExtension t2 : this.getChildExtensionsOfType(TransportExtension.class)) {
            transports.add(t2.getNamespace());
        }
        return transports;
    }

    private String getName() {
        return this.getAttributeAsString(CONFERENCE_NAME_ATTR_NAME);
    }
}

