/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.filtering;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.glassfish.jersey.message.filtering.EntityFiltering;
import org.glassfish.jersey.message.filtering.spi.FilteringHelper;

final class EntityFilteringHelper {
    public static Set<String> getFilteringScopes(Annotation[] annotations2) {
        return EntityFilteringHelper.getFilteringScopes(annotations2, true);
    }

    public static Set<String> getFilteringScopes(Annotation[] annotations2, boolean filter) {
        if (annotations2.length == 0) {
            return Collections.emptySet();
        }
        HashSet<String> contexts = new HashSet<String>(annotations2.length);
        for (Annotation annotation : annotations2 = filter ? EntityFilteringHelper.getFilteringAnnotations(annotations2) : annotations2) {
            contexts.add(annotation.annotationType().getName());
        }
        return contexts;
    }

    public static Annotation[] getFilteringAnnotations(Annotation[] annotations2) {
        if (annotations2 == null || annotations2.length == 0) {
            return FilteringHelper.EMPTY_ANNOTATIONS;
        }
        ArrayList<Annotation> filteringAnnotations = new ArrayList<Annotation>(annotations2.length);
        for (Annotation annotation : annotations2) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            for (Annotation metaAnnotation : annotationType.getDeclaredAnnotations()) {
                if (!(metaAnnotation instanceof EntityFiltering)) continue;
                filteringAnnotations.add(annotation);
            }
        }
        return filteringAnnotations.toArray(new Annotation[filteringAnnotations.size()]);
    }

    public static <T extends Annotation> T getAnnotation(Annotation[] annotations2, Class<T> clazz) {
        for (Annotation annotation : annotations2) {
            if (!annotation.annotationType().getClass().isAssignableFrom(clazz)) continue;
            return (T)annotation;
        }
        return null;
    }

    private EntityFilteringHelper() {
    }
}

