/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Arcs_Curves;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java2d.AnimatingControlsSurface;
import java2d.CustomControls;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class BezierAnim
extends AnimatingControlsSurface {
    private static final int NUMPTS = 6;
    protected BasicStroke solid = new BasicStroke(10.0f, 0, 1);
    protected BasicStroke dashed = new BasicStroke(10.0f, 0, 1, 10.0f, new float[]{5.0f}, 0.0f);
    private float[] animpts = new float[12];
    private float[] deltas = new float[12];
    protected Paint fillPaint;
    protected Paint drawPaint;
    protected boolean doFill = true;
    protected boolean doDraw = true;
    protected GradientPaint gradient;
    protected BasicStroke stroke;

    public BezierAnim() {
        this.setBackground(Color.WHITE);
        this.gradient = new GradientPaint(0.0f, 0.0f, Color.RED, 200.0f, 200.0f, Color.YELLOW);
        this.fillPaint = this.gradient;
        this.drawPaint = Color.BLUE;
        this.stroke = this.solid;
        this.setControls(new Component[]{new DemoControls(this)});
    }

    public void animate(float[] pts, float[] deltas, int index, int limit) {
        float newpt = pts[index] + deltas[index];
        if (newpt <= 0.0f) {
            newpt = -newpt;
            deltas[index] = (float)(Math.random() * 4.0 + 2.0);
        } else if (newpt >= (float)limit) {
            newpt = 2.0f * (float)limit - newpt;
            deltas[index] = -((float)(Math.random() * 4.0 + 2.0));
        }
        pts[index] = newpt;
    }

    @Override
    public void reset(int w, int h) {
        for (int i = 0; i < this.animpts.length; i += 2) {
            this.animpts[i + 0] = (float)(Math.random() * (double)w);
            this.animpts[i + 1] = (float)(Math.random() * (double)h);
            this.deltas[i + 0] = (float)(Math.random() * 6.0 + 4.0);
            this.deltas[i + 1] = (float)(Math.random() * 6.0 + 4.0);
            if (this.animpts[i + 0] > (float)w / 2.0f) {
                this.deltas[i + 0] = -this.deltas[i + 0];
            }
            if (!(this.animpts[i + 1] > (float)h / 2.0f)) continue;
            this.deltas[i + 1] = -this.deltas[i + 1];
        }
        this.gradient = new GradientPaint(0.0f, 0.0f, Color.RED, (float)w * 0.7f, (float)h * 0.7f, Color.YELLOW);
    }

    @Override
    public void step(int w, int h) {
        for (int i = 0; i < this.animpts.length; i += 2) {
            this.animate(this.animpts, this.deltas, i + 0, w);
            this.animate(this.animpts, this.deltas, i + 1, h);
        }
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        float[] ctrlpts = this.animpts;
        int len = ctrlpts.length;
        float prevx = ctrlpts[len - 2];
        float prevy = ctrlpts[len - 1];
        float curx = ctrlpts[0];
        float cury = ctrlpts[1];
        float midx = (curx + prevx) / 2.0f;
        float midy = (cury + prevy) / 2.0f;
        GeneralPath gp = new GeneralPath(1);
        gp.moveTo(midx, midy);
        for (int i = 2; i <= ctrlpts.length; i += 2) {
            float x1 = (midx + curx) / 2.0f;
            float y1 = (midy + cury) / 2.0f;
            prevx = curx;
            prevy = cury;
            if (i < ctrlpts.length) {
                curx = ctrlpts[i + 0];
                cury = ctrlpts[i + 1];
            } else {
                curx = ctrlpts[0];
                cury = ctrlpts[1];
            }
            midx = (curx + prevx) / 2.0f;
            midy = (cury + prevy) / 2.0f;
            float x2 = (prevx + midx) / 2.0f;
            float y2 = (prevy + midy) / 2.0f;
            gp.curveTo(x1, y1, x2, y2, midx, midy);
        }
        gp.closePath();
        if (this.doDraw) {
            g2.setPaint(this.drawPaint);
            g2.setStroke(this.stroke);
            g2.draw(gp);
        }
        if (this.doFill) {
            if (this.fillPaint instanceof GradientPaint) {
                this.fillPaint = this.gradient;
            }
            g2.setPaint(this.fillPaint);
            g2.fill(gp);
        }
    }

    public static void main(String[] argv) {
        BezierAnim.createDemoFrame(new BezierAnim());
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener {
        static final TexturePaint tp1;
        static final TexturePaint tp2;
        BezierAnim demo;
        static Paint[] drawPaints;
        static String[] drawName;
        static Paint[] fillPaints;
        String[] fillName = new String[]{"No Fill", "Green", "Green w/ Alpha", "Texture", "Gradient"};
        JMenu fillMenu;
        JMenu drawMenu;
        JMenuItem[] fillMI = new JMenuItem[fillPaints.length];
        JMenuItem[] drawMI = new JMenuItem[drawPaints.length];
        PaintedIcon[] fillIcons = new PaintedIcon[fillPaints.length];
        PaintedIcon[] drawIcons = new PaintedIcon[drawPaints.length];
        Font font = new Font("Serif", 0, 10);

        public DemoControls(BezierAnim demo) {
            super(demo.name);
            int i;
            this.demo = demo;
            JMenuBar drawMenuBar = new JMenuBar();
            this.add(drawMenuBar);
            JMenuBar fillMenuBar = new JMenuBar();
            this.add(fillMenuBar);
            this.drawMenu = drawMenuBar.add(new JMenu("Draw Choice"));
            this.drawMenu.setFont(this.font);
            for (i = 0; i < drawPaints.length; ++i) {
                this.drawIcons[i] = new PaintedIcon(drawPaints[i]);
                this.drawMI[i] = this.drawMenu.add(new JMenuItem(drawName[i]));
                this.drawMI[i].setFont(this.font);
                this.drawMI[i].setIcon(this.drawIcons[i]);
                this.drawMI[i].addActionListener(this);
            }
            this.drawMenu.setIcon(this.drawIcons[1]);
            this.fillMenu = fillMenuBar.add(new JMenu("Fill Choice"));
            this.fillMenu.setFont(this.font);
            for (i = 0; i < fillPaints.length; ++i) {
                this.fillIcons[i] = new PaintedIcon(fillPaints[i]);
                this.fillMI[i] = this.fillMenu.add(new JMenuItem(this.fillName[i]));
                this.fillMI[i].setFont(this.font);
                this.fillMI[i].setIcon(this.fillIcons[i]);
                this.fillMI[i].addActionListener(this);
            }
            this.fillMenu.setIcon(this.fillIcons[fillPaints.length - 1]);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            Object obj = e.getSource();
            for (i = 0; i < fillPaints.length; ++i) {
                if (!obj.equals(this.fillMI[i])) continue;
                this.demo.doFill = true;
                this.demo.fillPaint = fillPaints[i];
                this.fillMenu.setIcon(this.fillIcons[i]);
                break;
            }
            for (i = 0; i < drawPaints.length; ++i) {
                if (!obj.equals(this.drawMI[i])) continue;
                this.demo.doDraw = true;
                this.demo.drawPaint = drawPaints[i];
                this.demo.stroke = ((JMenuItem)obj).getText().endsWith("Dash") ? this.demo.dashed : this.demo.solid;
                this.drawMenu.setIcon(this.drawIcons[i]);
                break;
            }
            if (obj.equals(this.fillMI[0])) {
                this.demo.doFill = false;
            } else if (obj.equals(this.drawMI[0])) {
                this.demo.doDraw = false;
            }
            if (!this.demo.animating.running()) {
                this.demo.repaint();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 36);
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            while (this.thread == me) {
                block3: for (JMenuItem dmi : this.drawMI) {
                    dmi.doClick();
                    for (JMenuItem fmi : this.fillMI) {
                        fmi.doClick();
                        try {
                            Thread.sleep(3000L + (long)(Math.random() * 3000.0));
                        }
                        catch (InterruptedException e) {
                            continue block3;
                        }
                    }
                }
            }
            this.thread = null;
        }

        static {
            BufferedImage bi = new BufferedImage(2, 1, 1);
            bi.setRGB(0, 0, -16711936);
            bi.setRGB(1, 0, -65536);
            tp1 = new TexturePaint(bi, new Rectangle(0, 0, 2, 1));
            bi = new BufferedImage(2, 1, 1);
            bi.setRGB(0, 0, -16776961);
            bi.setRGB(1, 0, -65536);
            tp2 = new TexturePaint(bi, new Rectangle(0, 0, 2, 1));
            drawPaints = new Paint[]{new Color(0, 0, 0, 0), Color.BLUE, new Color(0, 0, 255, 126), Color.BLUE, tp2};
            drawName = new String[]{"No Draw", "Blue", "Blue w/ Alpha", "Blue Dash", "Texture"};
            fillPaints = new Paint[]{new Color(0, 0, 0, 0), Color.GREEN, new Color(0, 255, 0, 126), tp1, new GradientPaint(0.0f, 0.0f, Color.RED, 30.0f, 30.0f, Color.YELLOW)};
        }

        static class PaintedIcon
        implements Icon {
            Paint paint;

            public PaintedIcon(Paint p) {
                this.paint = p;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setPaint(this.paint);
                g2.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
                g2.setColor(Color.GRAY);
                g2.draw3DRect(x, y, this.getIconWidth() - 1, this.getIconHeight() - 1, true);
            }

            @Override
            public int getIconWidth() {
                return 12;
            }

            @Override
            public int getIconHeight() {
                return 12;
            }
        }
    }
}

