/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.utilities.soql;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import sun.jvm.hotspot.utilities.soql.DefaultScriptObject;
import sun.jvm.hotspot.utilities.soql.JSJavaFactory;

public class JSMap
extends DefaultScriptObject {
    private final Map map;
    private final JSJavaFactory factory;

    public JSMap(Map map, JSJavaFactory fac) {
        this.map = map;
        this.factory = fac;
    }

    @Override
    public Object get(String name) {
        if (this.map.containsKey(name)) {
            return this.wrapObject(this.map.get(name));
        }
        return super.get(name);
    }

    @Override
    public Object[] getIds() {
        Object[] superIds = super.getIds();
        Object[] tmp = this.map.keySet().toArray();
        Object[] res = new Object[superIds.length + tmp.length];
        System.arraycopy(tmp, 0, res, 0, tmp.length);
        System.arraycopy(superIds, 0, res, tmp.length, superIds.length);
        return res;
    }

    @Override
    public boolean has(String name) {
        if (this.map.containsKey(name)) {
            return true;
        }
        return super.has(name);
    }

    @Override
    public void put(String name, Object value) {
        if (!this.map.containsKey(name)) {
            super.put(name, value);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Set keys = this.map.keySet();
        buf.append('{');
        Iterator itr = keys.iterator();
        while (itr.hasNext()) {
            Object key = itr.next();
            buf.append(key);
            buf.append('=');
            buf.append(this.wrapObject(this.map.get(key)));
            if (!itr.hasNext()) continue;
            buf.append(", ");
        }
        buf.append('}');
        return buf.toString();
    }

    private Object wrapObject(Object obj) {
        return this.factory.newJSJavaWrapper(obj);
    }
}

