/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import sun.security.ssl.Alert;
import sun.security.ssl.CertificateStatus;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyExchange;
import sun.security.ssl.ServerHandshakeContext;

final class ServerKeyExchange {
    static final SSLConsumer handshakeConsumer = new ServerKeyExchangeConsumer();
    static final HandshakeProducer handshakeProducer = new ServerKeyExchangeProducer();

    ServerKeyExchange() {
    }

    private static final class ServerKeyExchangeConsumer
    implements SSLConsumer {
        private ServerKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            SSLKeyExchange sSLKeyExchange;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            clientHandshakeContext.handshakeConsumers.remove(SSLHandshake.SERVER_KEY_EXCHANGE.id);
            if (clientHandshakeContext.receivedCertReq) {
                clientHandshakeContext.receivedCertReq = false;
                throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected ServerKeyExchange handshake message");
            }
            SSLConsumer sSLConsumer = (SSLConsumer)clientHandshakeContext.handshakeConsumers.remove(SSLHandshake.CERTIFICATE_STATUS.id);
            if (sSLConsumer != null) {
                CertificateStatus.handshakeAbsence.absent(connectionContext, null);
            }
            if ((sSLKeyExchange = SSLKeyExchange.valueOf(clientHandshakeContext.negotiatedCipherSuite.keyExchange, clientHandshakeContext.negotiatedProtocol)) != null) {
                for (Map.Entry<Byte, SSLConsumer> entry : sSLKeyExchange.getHandshakeConsumers(clientHandshakeContext)) {
                    if (entry.getKey() != SSLHandshake.SERVER_KEY_EXCHANGE.id) continue;
                    entry.getValue().consume(connectionContext, byteBuffer);
                    return;
                }
            }
            throw clientHandshakeContext.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected ServerKeyExchange handshake message.");
        }
    }

    private static final class ServerKeyExchangeProducer
    implements HandshakeProducer {
        private ServerKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            SSLKeyExchange sSLKeyExchange = SSLKeyExchange.valueOf(serverHandshakeContext.negotiatedCipherSuite.keyExchange, serverHandshakeContext.negotiatedProtocol);
            if (sSLKeyExchange != null) {
                for (Map.Entry<Byte, HandshakeProducer> entry : sSLKeyExchange.getHandshakeProducers(serverHandshakeContext)) {
                    if (entry.getKey() != SSLHandshake.SERVER_KEY_EXCHANGE.id) continue;
                    return entry.getValue().produce(connectionContext, handshakeMessage);
                }
            }
            throw serverHandshakeContext.conContext.fatal(Alert.HANDSHAKE_FAILURE, "No ServerKeyExchange handshake message can be produced.");
        }
    }
}

