/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLException;
import sun.security.ssl.Utilities;

interface Record {
    public static final int maxMacSize = 48;
    public static final int maxDataSize = 16384;
    public static final int maxPadding = 256;
    public static final int maxIVLength = 16;
    public static final int maxFragmentSize = 18432;
    public static final boolean enableCBCProtection = Utilities.getBooleanProperty("jsse.enableCBCProtection", true);
    public static final int OVERFLOW_OF_INT08 = 256;
    public static final int OVERFLOW_OF_INT16 = 65536;
    public static final int OVERFLOW_OF_INT24 = 0x1000000;

    public static int getInt8(ByteBuffer byteBuffer) throws IOException {
        Record.verifyLength(byteBuffer, 1);
        return byteBuffer.get() & 0xFF;
    }

    public static int getInt16(ByteBuffer byteBuffer) throws IOException {
        Record.verifyLength(byteBuffer, 2);
        return (byteBuffer.get() & 0xFF) << 8 | byteBuffer.get() & 0xFF;
    }

    public static int getInt24(ByteBuffer byteBuffer) throws IOException {
        Record.verifyLength(byteBuffer, 3);
        return (byteBuffer.get() & 0xFF) << 16 | (byteBuffer.get() & 0xFF) << 8 | byteBuffer.get() & 0xFF;
    }

    public static int getInt32(ByteBuffer byteBuffer) throws IOException {
        Record.verifyLength(byteBuffer, 4);
        return (byteBuffer.get() & 0xFF) << 24 | (byteBuffer.get() & 0xFF) << 16 | (byteBuffer.get() & 0xFF) << 8 | byteBuffer.get() & 0xFF;
    }

    public static byte[] getBytes8(ByteBuffer byteBuffer) throws IOException {
        int n = Record.getInt8(byteBuffer);
        Record.verifyLength(byteBuffer, n);
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static byte[] getBytes16(ByteBuffer byteBuffer) throws IOException {
        int n = Record.getInt16(byteBuffer);
        Record.verifyLength(byteBuffer, n);
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static byte[] getBytes24(ByteBuffer byteBuffer) throws IOException {
        int n = Record.getInt24(byteBuffer);
        Record.verifyLength(byteBuffer, n);
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static void putInt8(ByteBuffer byteBuffer, int n) throws IOException {
        Record.verifyLength(byteBuffer, 1);
        byteBuffer.put((byte)(n & 0xFF));
    }

    public static void putInt16(ByteBuffer byteBuffer, int n) throws IOException {
        Record.verifyLength(byteBuffer, 2);
        byteBuffer.put((byte)(n >> 8 & 0xFF));
        byteBuffer.put((byte)(n & 0xFF));
    }

    public static void putInt24(ByteBuffer byteBuffer, int n) throws IOException {
        Record.verifyLength(byteBuffer, 3);
        byteBuffer.put((byte)(n >> 16 & 0xFF));
        byteBuffer.put((byte)(n >> 8 & 0xFF));
        byteBuffer.put((byte)(n & 0xFF));
    }

    public static void putInt32(ByteBuffer byteBuffer, int n) throws IOException {
        byteBuffer.put((byte)(n >> 24 & 0xFF));
        byteBuffer.put((byte)(n >> 16 & 0xFF));
        byteBuffer.put((byte)(n >> 8 & 0xFF));
        byteBuffer.put((byte)(n & 0xFF));
    }

    public static void putBytes8(ByteBuffer byteBuffer, byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            Record.verifyLength(byteBuffer, 1);
            Record.putInt8(byteBuffer, 0);
        } else {
            Record.verifyLength(byteBuffer, 1 + byArray.length);
            Record.putInt8(byteBuffer, byArray.length);
            byteBuffer.put(byArray);
        }
    }

    public static void putBytes16(ByteBuffer byteBuffer, byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            Record.verifyLength(byteBuffer, 2);
            Record.putInt16(byteBuffer, 0);
        } else {
            Record.verifyLength(byteBuffer, 2 + byArray.length);
            Record.putInt16(byteBuffer, byArray.length);
            byteBuffer.put(byArray);
        }
    }

    public static void putBytes24(ByteBuffer byteBuffer, byte[] byArray) throws IOException {
        if (byArray == null || byArray.length == 0) {
            Record.verifyLength(byteBuffer, 3);
            Record.putInt24(byteBuffer, 0);
        } else {
            Record.verifyLength(byteBuffer, 3 + byArray.length);
            Record.putInt24(byteBuffer, byArray.length);
            byteBuffer.put(byArray);
        }
    }

    public static void verifyLength(ByteBuffer byteBuffer, int n) throws SSLException {
        if (n > byteBuffer.remaining()) {
            throw new SSLException("Insufficient space in the buffer, may be cause by an unexpected end of handshake data.");
        }
    }
}

