/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class DeflaterOutputStream
extends FilterOutputStream {
    static final int DEFAULT_BUF_SIZE = 512;
    private static final int SYNC_FLUSH_MIN_BUF_SIZE = 7;
    protected Deflater def;
    protected byte[] buf;
    private boolean closed = false;
    private final boolean syncFlush;
    boolean usesDefaultDeflater = false;

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater, int n, boolean bl) {
        super(outputStream);
        if (outputStream == null || deflater == null) {
            throw new NullPointerException();
        }
        if (n <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        this.def = deflater;
        this.buf = new byte[n];
        this.syncFlush = bl;
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater, int n) {
        this(outputStream, deflater, n, false);
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater, boolean bl) {
        this(outputStream, deflater, 512, bl);
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater) {
        this(outputStream, deflater, 512, false);
    }

    public DeflaterOutputStream(OutputStream outputStream, boolean bl) {
        this(outputStream, new Deflater(), 512, bl);
        this.usesDefaultDeflater = true;
    }

    public DeflaterOutputStream(OutputStream outputStream) {
        this(outputStream, false);
        this.usesDefaultDeflater = true;
    }

    @Override
    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.def.finished()) {
            throw new IOException("write beyond end of stream");
        }
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        if (!this.def.finished()) {
            this.def.setInput(byArray, n, n2);
            while (!this.def.needsInput()) {
                this.deflate();
            }
        }
    }

    public void finish() throws IOException {
        if (!this.def.finished()) {
            try {
                this.def.finish();
                while (!this.def.finished()) {
                    this.deflate();
                }
            }
            catch (IOException iOException) {
                if (this.usesDefaultDeflater) {
                    this.def.end();
                }
                throw iOException;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                this.finish();
            }
            finally {
                if (this.usesDefaultDeflater) {
                    this.def.end();
                }
            }
            this.out.close();
            this.closed = true;
        }
    }

    protected void deflate() throws IOException {
        int n = this.def.deflate(this.buf, 0, this.buf.length);
        if (n > 0) {
            this.out.write(this.buf, 0, n);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.syncFlush && !this.def.finished()) {
            byte[] byArray;
            int n = 0;
            byte[] byArray2 = byArray = this.buf.length < 7 ? new byte[512] : this.buf;
            while ((n = this.def.deflate(byArray, 0, byArray.length, 2)) > 0) {
                this.out.write(byArray, 0, n);
                if (n >= byArray.length) continue;
            }
        }
        this.out.flush();
    }
}

