/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.JavaPackage;
import jadx.core.utils.Utils;
import jadx.gui.JadxWrapper;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.utils.UiUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JPackage
extends JNode {
    private static final long serialVersionUID = -4120718634156839804L;
    private static final ImageIcon PACKAGE_ICON = UiUtils.openSvgIcon("nodes/package");
    private String fullName;
    private String name;
    private boolean enabled;
    private List<JClass> classes;
    private List<JPackage> innerPackages;

    public JPackage(JavaPackage pkg, JadxWrapper wrapper) {
        this(pkg.getName(), pkg.getName(), JPackage.isPkgEnabled(wrapper, pkg.getName()), Utils.collectionMap((Collection)pkg.getClasses(), JClass::new), new ArrayList<JPackage>());
        this.update();
    }

    public JPackage(String fullName, JadxWrapper wrapper) {
        this(fullName, fullName, JPackage.isPkgEnabled(wrapper, fullName), new ArrayList<JClass>(), new ArrayList<JPackage>());
    }

    public JPackage(String fullName, String name) {
        this(fullName, name, true, Collections.emptyList(), Collections.emptyList());
    }

    private JPackage(String fullName, String name, boolean enabled, List<JClass> classes, List<JPackage> innerPackages) {
        this.fullName = fullName;
        this.name = name;
        this.enabled = enabled;
        this.classes = classes;
        this.innerPackages = innerPackages;
    }

    private static boolean isPkgEnabled(JadxWrapper wrapper, String fullPkgName) {
        List<String> excludedPackages = wrapper.getExcludedPackages();
        return excludedPackages.isEmpty() || excludedPackages.stream().filter(p -> !p.isEmpty()).noneMatch(p -> fullPkgName.equals(p) || fullPkgName.startsWith(p + '.'));
    }

    public final void update() {
        this.removeAllChildren();
        if (this.isEnabled()) {
            for (JPackage pkg : this.innerPackages) {
                pkg.update();
                this.add(pkg);
            }
            for (JClass cls : this.classes) {
                cls.update();
                this.add(cls);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean canRename() {
        return true;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void updateBothNames(String fullName, String name, JadxWrapper wrapper) {
        this.fullName = fullName;
        this.name = name;
        this.enabled = JPackage.isPkgEnabled(wrapper, fullName);
    }

    public void updateName(String name) {
        this.name = name;
    }

    public List<JPackage> getInnerPackages() {
        return this.innerPackages;
    }

    public void setInnerPackages(List<JPackage> innerPackages) {
        this.innerPackages = innerPackages;
    }

    public List<JClass> getClasses() {
        return this.classes;
    }

    public void setClasses(List<JClass> classes) {
        this.classes = classes;
    }

    @Override
    public Icon getIcon() {
        return PACKAGE_ICON;
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.name.equals(((JPackage)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String makeString() {
        return this.name;
    }

    @Override
    public String makeLongString() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

