/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file.nio;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import org.gradle.internal.file.FilePermissionHandler;
import org.gradle.internal.file.nio.PosixFilePermissionConverter;

public class PosixJdk7FilePermissionHandler
implements FilePermissionHandler {
    @Override
    public int getUnixMode(File file) throws IOException {
        PosixFileAttributes posixFileAttributes = Files.readAttributes(file.toPath(), PosixFileAttributes.class, new LinkOption[0]);
        return PosixFilePermissionConverter.convertToInt(posixFileAttributes.permissions());
    }

    @Override
    public void chmod(File f, int mode) throws IOException {
        PosixFileAttributeView fileAttributeView = Files.getFileAttributeView(f.toPath(), PosixFileAttributeView.class, new LinkOption[0]);
        fileAttributeView.setPermissions(PosixFilePermissionConverter.convertToPermissionsSet(mode));
    }
}

