/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.tasks.options.OptionReader;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.configuration.TaskDetailPrinter;
import org.gradle.configuration.TaskDetailsModel;
import org.gradle.execution.selection.BuildTaskSelector;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.layout.ResolvedBuildLayout;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.util.GradleVersion;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Produces only non-cacheable console output")
public abstract class Help
extends DefaultTask {
    private final Property<String> taskPath = this.getObjectFactory().property(String.class);
    private final Property<TaskDetailsModel> taskModel = this.getObjectFactory().property(TaskDetailsModel.class).convention(this.taskPath.map(this::mapFromTaskPath));

    public Help() {
        this.taskModel.finalizeValueOnRead();
    }

    private Property<String> getTaskPath() {
        return this.taskPath;
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected StyledTextOutputFactory getTextOutputFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected BuildClientMetaData getClientMetaData() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected BuildTaskSelector.BuildSpecificSelector getTaskSelector() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected OptionReader getOptionReader() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ResolvedBuildLayout getResolvedBuildLayout() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected DocumentationRegistry getDocumentationRegistry() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    void displayHelp() {
        StyledTextOutput output = this.getTextOutputFactory().create(Help.class);
        BuildClientMetaData metaData = this.getClientMetaData();
        if (this.getTaskPath().isPresent()) {
            this.printTaskHelp(output);
        } else {
            this.printDefaultHelp(output, metaData);
        }
    }

    private void printTaskHelp(StyledTextOutput output) {
        TaskDetailsModel taskDetailModel = (TaskDetailsModel)this.taskModel.get();
        TaskDetailPrinter taskDetailPrinter = new TaskDetailPrinter(taskDetailModel.getTaskPath(), taskDetailModel.getTasks());
        taskDetailPrinter.print(output);
    }

    private void printDefaultHelp(StyledTextOutput output, BuildClientMetaData metaData) {
        output.println();
        output.formatln("Welcome to Gradle %s.", new Object[]{GradleVersion.current().getVersion()});
        output.println();
        if (this.getResolvedBuildLayout().isBuildDefinitionMissing()) {
            output.append((CharSequence)"Directory '");
            output.append((CharSequence)this.getResolvedBuildLayout().getCurrentDirectory().getAbsolutePath());
            output.println((Object)"' does not contain a Gradle build.");
            output.println();
            output.text((Object)"To create a new build in this directory, run ");
            metaData.describeCommand((Appendable)output.withStyle(StyledTextOutput.Style.UserInput), new String[]{"init"});
            output.println();
            output.println();
            output.append((CharSequence)"For more detail on the 'init' task, see ");
            output.withStyle(StyledTextOutput.Style.UserInput).append((CharSequence)this.getDocumentationRegistry().getDocumentationFor("build_init_plugin"));
            output.println();
            output.println();
            output.append((CharSequence)"For more detail on creating a Gradle build, see ");
            output.withStyle(StyledTextOutput.Style.UserInput).append((CharSequence)this.getDocumentationRegistry().getDocumentationFor("tutorial_using_tasks"));
            output.println();
        } else {
            output.text((Object)"To run a build, run ");
            metaData.describeCommand((Appendable)output.withStyle(StyledTextOutput.Style.UserInput), new String[]{"<task> ..."});
            output.println();
            output.println();
            output.text((Object)"To see a list of available tasks, run ");
            metaData.describeCommand((Appendable)output.withStyle(StyledTextOutput.Style.UserInput), new String[]{"tasks"});
            output.println();
            output.println();
            output.text((Object)"To see more detail about a task, run ");
            metaData.describeCommand((Appendable)output.withStyle(StyledTextOutput.Style.UserInput), new String[]{"help --task <task>"});
            output.println();
        }
        output.println();
        output.text((Object)"To see a list of command-line options, run ");
        metaData.describeCommand((Appendable)output.withStyle(StyledTextOutput.Style.UserInput), new String[]{"--help"});
        output.println();
        output.println();
        output.append((CharSequence)"For more detail on using Gradle, see ");
        output.withStyle(StyledTextOutput.Style.UserInput).append((CharSequence)this.getDocumentationRegistry().getDocumentationFor("command_line_interface"));
        output.println();
        output.println();
        output.text((Object)"For troubleshooting, visit ");
        output.withStyle(StyledTextOutput.Style.UserInput).text((Object)"https://help.gradle.org");
        output.println();
    }

    @Option(option="task", description="The task to show help for.")
    public void setTaskPath(String taskPath) {
        this.getTaskPath().set((Object)taskPath);
    }

    private TaskDetailsModel mapFromTaskPath(String taskPath) {
        return TaskDetailsModel.from(taskPath, this.getTaskSelector(), this.getOptionReader());
    }
}

