/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kms.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.kms.model.RecipientInfo;
import java.nio.ByteBuffer;

@SdkInternalApi
public class RecipientInfoMarshaller {
    private static final MarshallingInfo<String> KEYENCRYPTIONALGORITHM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("KeyEncryptionAlgorithm").build();
    private static final MarshallingInfo<ByteBuffer> ATTESTATIONDOCUMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AttestationDocument").build();
    private static final RecipientInfoMarshaller instance = new RecipientInfoMarshaller();

    public static RecipientInfoMarshaller getInstance() {
        return instance;
    }

    public void marshall(RecipientInfo recipientInfo, ProtocolMarshaller protocolMarshaller) {
        if (recipientInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)recipientInfo.getKeyEncryptionAlgorithm(), KEYENCRYPTIONALGORITHM_BINDING);
            protocolMarshaller.marshall((Object)recipientInfo.getAttestationDocument(), ATTESTATIONDOCUMENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

