/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.model;

import java.util.Locale;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.internal.fingerprint.FileNormalizer;

public enum InputNormalizer implements FileNormalizer
{
    ABSOLUTE_PATH(false),
    RELATIVE_PATH(false),
    NAME_ONLY(false),
    IGNORE_PATH(true),
    RUNTIME_CLASSPATH(true),
    COMPILE_CLASSPATH(true);

    private final boolean ignoreDirectories;
    private final String description;

    private InputNormalizer(boolean ignoreDirectories) {
        this.ignoreDirectories = ignoreDirectories;
        this.description = this.name().toLowerCase(Locale.ROOT).replace('_', ' ');
    }

    public static FileNormalizer determineNormalizerForPathSensitivity(PathSensitivity pathSensitivity) {
        switch (pathSensitivity) {
            case NONE: {
                return IGNORE_PATH;
            }
            case NAME_ONLY: {
                return NAME_ONLY;
            }
            case RELATIVE: {
                return RELATIVE_PATH;
            }
            case ABSOLUTE: {
                return ABSOLUTE_PATH;
            }
        }
        throw new IllegalArgumentException("Unknown path sensitivity: " + pathSensitivity);
    }

    public boolean isIgnoringDirectories() {
        return this.ignoreDirectories;
    }

    public String toString() {
        return this.description;
    }
}

