/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.msvcpp;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.rubygrapefruit.platform.SystemInfo;
import net.rubygrapefruit.platform.WindowsRegistry;
import org.gradle.internal.logging.text.DiagnosticsVisitor;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.LegacyWindowsSdkLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsComponentLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsKitSdkInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsKitWindowsSdkLocator;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdkInstall;
import org.gradle.nativeplatform.toolchain.internal.msvcpp.WindowsSdkLocator;
import org.gradle.platform.base.internal.toolchain.SearchResult;

public class DefaultWindowsSdkLocator
implements WindowsSdkLocator {
    private final WindowsSdkLocator legacyWindowsSdkLocator;
    private final WindowsComponentLocator<WindowsKitSdkInstall> windowsKitWindowsSdkLocator;

    @VisibleForTesting
    DefaultWindowsSdkLocator(WindowsSdkLocator legacyWindowsSdkLocator, WindowsComponentLocator<WindowsKitSdkInstall> windowsKitWindowsSdkLocator) {
        this.legacyWindowsSdkLocator = legacyWindowsSdkLocator;
        this.windowsKitWindowsSdkLocator = windowsKitWindowsSdkLocator;
    }

    public DefaultWindowsSdkLocator(OperatingSystem operatingSystem, WindowsRegistry windowsRegistry, SystemInfo systemInfo) {
        this(new LegacyWindowsSdkLocator(operatingSystem, windowsRegistry), new WindowsKitWindowsSdkLocator(windowsRegistry, systemInfo));
    }

    @Override
    public SearchResult<WindowsSdkInstall> locateComponent(@Nullable File candidate) {
        return new SdkSearchResult(this.legacyWindowsSdkLocator.locateComponent(candidate), this.windowsKitWindowsSdkLocator.locateComponent(candidate));
    }

    @Override
    public List<WindowsSdkInstall> locateAllComponents() {
        ArrayList<WindowsSdkInstall> allSdks = new ArrayList<WindowsSdkInstall>();
        allSdks.addAll(this.legacyWindowsSdkLocator.locateAllComponents());
        allSdks.addAll(this.windowsKitWindowsSdkLocator.locateAllComponents());
        return allSdks;
    }

    private static class SdkSearchResult
    implements SearchResult<WindowsSdkInstall> {
        final SearchResult<WindowsSdkInstall> legacySearchResult;
        final SearchResult<WindowsKitSdkInstall> windowsKitSearchResult;

        SdkSearchResult(SearchResult<WindowsSdkInstall> legacySearchResult, SearchResult<WindowsKitSdkInstall> windowsKitSearchResult) {
            this.legacySearchResult = legacySearchResult;
            this.windowsKitSearchResult = windowsKitSearchResult;
        }

        public WindowsSdkInstall getComponent() {
            if (this.windowsKitSearchResult.isAvailable()) {
                return (WindowsSdkInstall)this.windowsKitSearchResult.getComponent();
            }
            if (this.legacySearchResult.isAvailable()) {
                return (WindowsSdkInstall)this.legacySearchResult.getComponent();
            }
            return null;
        }

        public boolean isAvailable() {
            return this.windowsKitSearchResult.isAvailable() || this.legacySearchResult.isAvailable();
        }

        public void explain(DiagnosticsVisitor visitor) {
            this.windowsKitSearchResult.explain(visitor);
        }
    }
}

