/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleIdentifier;

public class ImmutableModuleReplacements {
    private final ImmutableMap<ModuleIdentifier, Replacement> replacements;

    public ImmutableModuleReplacements(ImmutableMap<ModuleIdentifier, Replacement> replacements) {
        this.replacements = replacements;
    }

    @Nullable
    public Replacement getReplacementFor(ModuleIdentifier sourceModule) {
        return (Replacement)this.replacements.get((Object)sourceModule);
    }

    public static class Replacement {
        private final ModuleIdentifier target;
        private final String reason;

        Replacement(ModuleIdentifier target, @Nullable String reason) {
            this.target = target;
            this.reason = reason;
        }

        public ModuleIdentifier getTarget() {
            return this.target;
        }

        @Nullable
        public String getReason() {
            return this.reason;
        }
    }
}

