/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.xml.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.galleon.xml.util.AttributeValue;
import org.jboss.galleon.xml.util.CDataNode;
import org.jboss.galleon.xml.util.CommentNode;
import org.jboss.galleon.xml.util.ElementNode;
import org.jboss.galleon.xml.util.ProcessingInstructionNode;
import org.jboss.galleon.xml.util.TextNode;

public class NodeParser {
    private final String namespaceURI;

    public NodeParser() {
        this(null);
    }

    public NodeParser(String namespaceURI) {
        this.namespaceURI = namespaceURI;
    }

    public ElementNode parseNode(XMLStreamReader reader, String nodeName) throws XMLStreamException {
        ElementNode rootNode;
        if (reader.getEventType() != 1) {
            throw new XMLStreamException("Expected START_ELEMENT", reader.getLocation());
        }
        if (!reader.getLocalName().equals(nodeName)) {
            throw new XMLStreamException("Expected <" + nodeName + ">", reader.getLocation());
        }
        ElementNode currentNode = rootNode = this.createNodeWithAttributesAndNs(reader, null);
        while (reader.hasNext()) {
            int type = reader.next();
            switch (type) {
                case 2: {
                    currentNode = currentNode.getParent();
                    String name = reader.getLocalName();
                    if (!name.equals(nodeName)) break;
                    return rootNode;
                }
                case 1: {
                    ElementNode childNode = this.createNodeWithAttributesAndNs(reader, currentNode);
                    currentNode.addChild(childNode);
                    currentNode = childNode;
                    break;
                }
                case 5: {
                    String comment = reader.getText();
                    currentNode.addChild(new CommentNode(comment));
                    break;
                }
                case 12: {
                    currentNode.addChild(new CDataNode(reader.getText()));
                    break;
                }
                case 4: {
                    if (reader.isWhiteSpace()) break;
                    currentNode.addChild(new TextNode(reader.getText()));
                    break;
                }
                case 3: {
                    ProcessingInstructionNode node = this.parseProcessingInstruction(reader, currentNode);
                    if (node == null) break;
                    currentNode.addChild(node);
                    break;
                }
            }
        }
        throw new XMLStreamException("Element was not terminated", reader.getLocation());
    }

    private ElementNode createNodeWithAttributesAndNs(XMLStreamReader reader, ElementNode parent) {
        String namespace = reader.getNamespaceURI() != null && reader.getNamespaceURI().length() > 0 ? reader.getNamespaceURI() : this.namespaceURI;
        ElementNode childNode = new ElementNode(parent, reader.getLocalName(), namespace);
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            childNode.addAttribute(name, this.createAttributeValue(value));
        }
        return childNode;
    }

    protected ProcessingInstructionNode parseProcessingInstruction(XMLStreamReader reader, ElementNode parent) throws XMLStreamException {
        return null;
    }

    protected Map<String, String> parseProcessingInstructionData(String data) {
        if (data == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> attributes = new HashMap<String, String>();
        StringBuilder builder = new StringBuilder();
        String name = null;
        boolean READ_NAME = true;
        int ATTRIBUTE_START = 3;
        int ATTRIBUTE = 4;
        int state = 1;
        char[] chars = data.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (state == 1) {
                if (c == '=') {
                    state = 3;
                    name = builder.toString();
                    builder = new StringBuilder();
                    continue;
                }
                if (c == ' ') continue;
                builder.append(c);
                continue;
            }
            if (state == 3) {
                state = 4;
                continue;
            }
            if (state != 4) continue;
            if (c == '\"') {
                attributes.put(name.toString(), builder.toString());
                builder = new StringBuilder();
                state = 1;
                continue;
            }
            builder.append(c);
        }
        return attributes;
    }

    protected AttributeValue createAttributeValue(String attributeValue) {
        return new AttributeValue(attributeValue);
    }
}

