/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.galleon.universe.FeaturePackLocation;
import org.jboss.galleon.util.StringUtils;

public interface BaseErrors {
    public static String pathDoesNotExist(Path p) {
        return "Failed to locate " + p.toAbsolutePath();
    }

    public static String mkdirs(Path p) {
        return "Failed to make directories " + p.toAbsolutePath();
    }

    public static String readDirectory(Path p) {
        return "Failed to read directory " + p.toAbsolutePath();
    }

    public static String notADir(Path p) {
        return p.toAbsolutePath() + " is not a directory";
    }

    public static String homeDirNotUsable(Path p) {
        return p + " has to be empty or contain a provisioned installation to be used by the tool";
    }

    public static String noVersionAvailable(FeaturePackLocation fpl) {
        return "No version is available for " + fpl;
    }

    public static String defaultChannelNotConfigured(String producer) {
        return "Default channel has not been configured for feature-pack producer " + producer;
    }

    public static String frequencyNotSupported(Collection<String> frequencies, FeaturePackLocation fpl) {
        StringBuilder buf = new StringBuilder();
        buf.append("The frequency specified in ").append(fpl).append(" is not supported, the producer ");
        if (frequencies.isEmpty()) {
            buf.append(" does not suport frequencies");
        } else {
            buf.append("supported frequencies are ");
            Object[] arr = frequencies.toArray(new String[frequencies.size()]);
            Arrays.sort(arr);
            StringUtils.append(buf, Arrays.asList(arr));
        }
        return buf.toString();
    }

    public static String writeFile(Path p) {
        return "Failed to write to " + p.toAbsolutePath();
    }

    public static String packageExcludeInclude(String packageName) {
        return "Attempt to explicitly include and exclude package " + packageName;
    }

    public static String unknownFeaturePackDependencyName(String depName) {
        return depName + " was not found among the feature-pack dependencies";
    }

    public static String unknownFeaturePack(FeaturePackLocation.FPID fpid) {
        return "Feature-pack " + fpid + " not found in the configuration";
    }

    public static String featurePackAlreadyConfigured(FeaturePackLocation.ProducerSpec producer) {
        return "Feature-pack " + producer + " already present in the configuration";
    }

    public static String unknownFeaturePackDependencyName(FeaturePackLocation.FPID fpid, String pkgName, String depName) {
        return fpid + " package " + pkgName + " references unknown feature-pack dependency " + depName;
    }

    public static String duplicateDependencyName(String name) {
        return "Dependency with name " + name + " already exists";
    }

    public static String configLayerCanEitherBeIncludedOrExcluded(String configModel, String configName, String layerName) {
        return "Configuration layer " + layerName + " appears to be included and excluded in the same configuration " + (String)(configModel == null ? configName : configModel + ":" + configName);
    }

    public static String copyFile(Path src, Path target) {
        return "Failed to copy " + src + " to " + target;
    }

    public static String hashCalculation(Path path) {
        return "Hash calculation failed for " + path;
    }

    public static String fsEntryInit(Path p) {
        return "Failed to process child entries for " + p;
    }

    public static String unexpectedPackageDependencyType(String name, int type) {
        return "Unexpected dependency type " + type + " on package " + name;
    }

    public static String parseXml(Path p) {
        return "Failed to parse " + p.toAbsolutePath();
    }

    public static String requiredPassiveDependency(String name) {
        return "Required dependency on " + name + " cannot be passive";
    }
}

