/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai;

import java.util.Comparator;
import java.util.function.Predicate;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.ai.AIMain;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.ValuedAIObject;

public class TileImprovementPlan
extends ValuedAIObject {
    private static final Logger logger = Logger.getLogger(TileImprovementPlan.class.getName());
    public static final String TAG = "tileImprovementPlan";
    private TileImprovementType type;
    private Tile target;
    private AIUnit pioneer = null;
    private static final String PIONEER_TAG = "pioneer";
    private static final String TARGET_TAG = "target";
    private static final String TYPE_TAG = "type";

    public TileImprovementPlan(AIMain aiMain, String id) {
        super(aiMain, id);
        this.type = null;
        this.target = null;
        this.pioneer = null;
        this.initialized = false;
    }

    public TileImprovementPlan(AIMain aiMain, Tile target, TileImprovementType type, int value) {
        super(aiMain, "tileImprovementPlan:" + aiMain.getNextId());
        this.target = target;
        this.type = type;
        this.pioneer = null;
        this.setValue(value);
        this.setInitialized();
    }

    public TileImprovementPlan(AIMain aiMain, FreeColXMLReader xr) throws XMLStreamException {
        super(aiMain, xr);
        this.setInitialized();
    }

    @Override
    public final void setInitialized() {
        this.initialized = this.getType() != null && this.getTarget() != null;
    }

    public final AIUnit getPioneer() {
        return this.pioneer;
    }

    public final void setPioneer(AIUnit pioneer) {
        this.pioneer = pioneer;
    }

    public final TileImprovementType getType() {
        return this.type;
    }

    public final void setType(TileImprovementType type) {
        this.type = type;
    }

    public final Tile getTarget() {
        return this.target;
    }

    public static TileImprovementType getBestTileImprovementType(Tile tile, GoodsType goodsType) {
        Specification spec = tile.getSpecification();
        Predicate<TileImprovementType> goodTIPred = it -> !it.isNatural() && it.isTileTypeAllowed(tile.getType()) && it.getExpendedAmount() <= 1 && tile.getTileImprovement((TileImprovementType)it) == null;
        Comparator<TileImprovementType> bestTIComp = CollectionUtils.cachingIntComparator(it -> it.getImprovementValue(tile, goodsType));
        TileImprovementType best = CollectionUtils.maximize(spec.getTileImprovementTypeList(), goodTIPred, bestTIComp);
        return best == null || best.getImprovementValue(tile, goodsType) <= 0 ? null : best;
    }

    public boolean update(GoodsType goodsType) {
        TileImprovementType type = TileImprovementPlan.getBestTileImprovementType(this.target, goodsType);
        if (type == null) {
            return false;
        }
        this.setType(type);
        this.setValue(type.getImprovementValue(this.target, goodsType));
        return true;
    }

    public boolean isComplete() {
        return this.target != null && this.target.hasTileImprovement(this.getType());
    }

    public boolean validate() {
        if (this.type == null) {
            logger.warning("Removing typeless TileImprovementPlan");
            this.dispose();
            return false;
        }
        if (this.target == null) {
            logger.warning("Removing targetless TileImprovementPlan");
            this.dispose();
            return false;
        }
        if (this.getPioneer() != null && (this.getPioneer().getUnit() == null || this.getPioneer().getUnit().isDisposed())) {
            logger.warning("Clearing broken pioneer for TileImprovementPlan");
            this.setPioneer(null);
        }
        return true;
    }

    @Override
    public void dispose() {
        this.pioneer = null;
        super.dispose();
    }

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        if (this.pioneer != null) {
            result = result.combine(this.pioneer.checkIntegrity(fix, lb));
        }
        if (this.type == null) {
            lb.add("\n  Tile improvement plan without type: ", this.getId());
            result = result.fail();
        } else if (this.target == null) {
            lb.add("\n  Tile improvement plan without target: ", this.getId());
            result = result.fail();
        }
        return result;
    }

    @Override
    public void toXML(FreeColXMLWriter xw) throws XMLStreamException {
        if (this.validate()) {
            this.toXML(xw, TAG);
        }
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(TYPE_TAG, this.type);
        xw.writeAttribute(TARGET_TAG, this.target);
        if (this.pioneer != null && this.pioneer.checkIntegrity(false) == Constants.IntegrityType.INTEGRITY_GOOD) {
            xw.writeAttribute(PIONEER_TAG, this.pioneer);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        AIMain aiMain = this.getAIMain();
        Specification spec = this.getSpecification();
        this.type = xr.getType(spec, TYPE_TAG, TileImprovementType.class, null);
        this.pioneer = xr.hasAttribute(PIONEER_TAG) ? xr.makeAIObject(aiMain, PIONEER_TAG, AIUnit.class, null, true) : null;
        this.target = xr.getAttribute(this.getGame(), TARGET_TAG, Tile.class, (Tile)null);
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof TileImprovementPlan)) {
            return false;
        }
        TileImprovementPlan other = (TileImprovementPlan)o;
        return Utils.equals(this.type, other.type) && Utils.equals(this.target, other.target) && Utils.equals(this.pioneer, other.pioneer) && super.equals(other);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 37 * hash + Utils.hashCode(this.type);
        hash = 37 * hash + Utils.hashCode(this.target);
        return 37 * hash + Utils.hashCode(this.pioneer);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append('[').append(this.getId()).append(' ').append(this.type == null ? "null" : this.type.getSuffix()).append(" at ").append(this.target == null ? "null" : this.target.toShortString()).append('/').append(this.getValue()).append(']');
        return sb.toString();
    }
}

