/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.common.option.OptionGroup;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class UpdateGameOptionsMessage
extends ObjectMessage {
    public static final String TAG = "updateGameOptions";

    public UpdateGameOptionsMessage(OptionGroup optionGroup) {
        super(TAG);
        this.appendChild(optionGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateGameOptionsMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        this((OptionGroup)null);
        FreeColXMLReader.ReadScope rs = xr.replaceScope(FreeColXMLReader.ReadScope.NOINTERN);
        OptionGroup optionGroup = null;
        try {
            while (xr.moreTags()) {
                String tag = xr.getLocalName();
                if ("optionGroup".equals(tag)) {
                    if (optionGroup == null) {
                        optionGroup = xr.readFreeColObject(game, OptionGroup.class);
                    } else {
                        this.expected(TAG, tag);
                    }
                } else {
                    this.expected("optionGroup", tag);
                }
                xr.expectTag(tag);
            }
            xr.expectTag(TAG);
        }
        finally {
            xr.replaceScope(rs);
        }
        this.appendChild(optionGroup);
    }

    private OptionGroup getGameOptions() {
        return this.getChild(0, OptionGroup.class);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        OptionGroup gameOptions = this.getGameOptions();
        if (!freeColClient.isInGame()) {
            this.pgc(freeColClient).updateGameOptionsHandler(gameOptions);
        }
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        if (serverPlayer == null) {
            return ChangeSet.clientError((ChangeSet.See)null, "Missing serverPlayer");
        }
        if (!serverPlayer.isAdmin()) {
            return serverPlayer.clientError("Not an admin: " + serverPlayer);
        }
        if (freeColServer.getServerState() != FreeColServer.ServerState.PRE_GAME) {
            return serverPlayer.clientError("Can not change game options, server state = " + freeColServer.getServerState());
        }
        OptionGroup gameOptions = this.getGameOptions();
        if (gameOptions == null) {
            return serverPlayer.clientError("No game options to merge");
        }
        return this.pgc(freeColServer).updateGameOptions(serverPlayer, gameOptions);
    }
}

