/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerPlayer;

public class LogoutMessage
extends AttributeMessage {
    public static final String TAG = "logout";
    private static final String PLAYER_TAG = "player";
    private static final String REASON_TAG = "reason";

    public LogoutMessage(Player player, Game.LogoutReason reason) {
        super(TAG, PLAYER_TAG, player.getId(), REASON_TAG, String.valueOf((Object)reason));
    }

    public LogoutMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, PLAYER_TAG, REASON_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Player player = this.getPlayer(game);
        Game.LogoutReason reason = this.getReason();
        if (player == null) {
            return;
        }
        if (freeColClient.isInGame()) {
            this.igc(freeColClient).logoutHandler(player, reason);
        } else {
            this.pgc(freeColClient).logoutHandler(player, reason);
        }
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        if (serverPlayer == null) {
            return null;
        }
        logger.info("Handling logout by " + serverPlayer.getName());
        Game.LogoutReason reason = this.getReason();
        ChangeSet cs = null;
        switch (freeColServer.getServerState()) {
            case PRE_GAME: 
            case LOAD_GAME: {
                break;
            }
            case IN_GAME: {
                boolean endTurn = false;
                switch (reason) {
                    case DEFEATED: {
                        endTurn = true;
                        break;
                    }
                    case LOGIN: {
                        break;
                    }
                    case MAIN_TITLE: 
                    case NEW_GAME: 
                    case QUIT: {
                        if (freeColServer.getSinglePlayer() || serverPlayer.isAdmin()) {
                            freeColServer.endGame();
                            break;
                        }
                        endTurn = true;
                        break;
                    }
                }
                if (!endTurn || freeColServer.getGame().getCurrentPlayer() != serverPlayer) break;
                cs = freeColServer.getInGameController().endTurn(serverPlayer);
                break;
            }
            case END_GAME: {
                return null;
            }
        }
        if (cs == null) {
            cs = new ChangeSet();
        }
        cs.add(ChangeSet.See.only(serverPlayer), new LogoutMessage(serverPlayer, reason));
        freeColServer.updateMetaServer();
        return cs;
    }

    public Player getPlayer(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(PLAYER_TAG), Player.class);
    }

    public Game.LogoutReason getReason() {
        return Enum.valueOf(Game.LogoutReason.class, this.getStringAttribute(REASON_TAG));
    }
}

