/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class AssignTeacherMessage
extends AttributeMessage {
    public static final String TAG = "assignTeacher";
    private static final String STUDENT_TAG = "student";
    private static final String TEACHER_TAG = "teacher";

    public AssignTeacherMessage(Unit student, Unit teacher) {
        super(TAG, STUDENT_TAG, student.getId(), TEACHER_TAG, teacher.getId());
    }

    public AssignTeacherMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, STUDENT_TAG, TEACHER_TAG);
    }

    @Override
    public boolean currentPlayerMessage() {
        return true;
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit teacher;
        Unit student;
        String studentId = this.getStringAttribute(STUDENT_TAG);
        String teacherId = this.getStringAttribute(TEACHER_TAG);
        try {
            student = serverPlayer.getOurFreeColGameObject(studentId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        try {
            teacher = serverPlayer.getOurFreeColGameObject(teacherId, Unit.class);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (student.getColony() == null) {
            return serverPlayer.clientError("Student not in colony: " + studentId);
        }
        if (!student.isInColony()) {
            return serverPlayer.clientError("Student not working colony: " + studentId);
        }
        if (teacher.getColony() == null) {
            return serverPlayer.clientError("Teacher not in colony: " + teacherId);
        }
        if (!teacher.getColony().canTrain(teacher)) {
            return serverPlayer.clientError("Teacher can not teach: " + teacherId);
        }
        if (student.getColony() != teacher.getColony()) {
            return serverPlayer.clientError("Student and teacher not in same colony: " + studentId);
        }
        if (!student.canBeStudent(teacher)) {
            return serverPlayer.clientError("Student can not be taught by teacher: " + studentId);
        }
        return this.igc(freeColServer).assignTeacher(serverPlayer, student, teacher);
    }
}

