/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.Utils;

public class ProductionType
extends FreeColSpecObject {
    public static final String TAG = "production";
    public static final List<AbstractGoods> EMPTY_LIST = Collections.emptyList();
    private boolean unattended;
    private String productionLevel;
    private List<AbstractGoods> outputs = null;
    private List<AbstractGoods> inputs = null;
    private static final String UNATTENDED_TAG = "unattended";
    private static final String GOODS_TYPE_TAG = "goods-type";
    private static final String INPUT_TAG = "input";
    private static final String OUTPUT_TAG = "output";
    private static final String PRODUCTION_LEVEL_TAG = "production-level";
    private static final String OLD_PRODUCTION_LEVEL_TAG = "productionLevel";

    public ProductionType(Specification specification) {
        super(specification);
    }

    private ProductionType(List<AbstractGoods> outputs) {
        this((Specification)null);
        this.outputs = outputs;
    }

    public ProductionType(List<AbstractGoods> inputs, List<AbstractGoods> outputs) {
        this(outputs);
        this.inputs = inputs;
    }

    public ProductionType(AbstractGoods output, boolean unattended, String level) {
        this(new ArrayList<AbstractGoods>());
        this.outputs.add(output);
        this.unattended = unattended;
        this.productionLevel = level;
    }

    public ProductionType(GoodsType input, GoodsType output, int amount) {
        this((Specification)null);
        if (input != null) {
            this.inputs = new ArrayList<AbstractGoods>();
            this.inputs.add(new AbstractGoods(input, amount));
        }
        if (output != null) {
            this.outputs = new ArrayList<AbstractGoods>();
            this.outputs.add(new AbstractGoods(output, amount));
        }
    }

    public ProductionType(FreeColXMLReader xr, Specification specification) throws XMLStreamException {
        this(specification);
        this.readFromXML(xr);
    }

    public final boolean getUnattended() {
        return this.unattended;
    }

    public final void setUnattended(boolean unattended) {
        this.unattended = unattended;
    }

    public final String getProductionLevel() {
        return this.productionLevel;
    }

    public boolean appliesTo(String level) {
        return level == null || this.productionLevel == null || level.equals(this.productionLevel);
    }

    public boolean appliesExactly(String level) {
        return level != null && level.equals(this.productionLevel);
    }

    public final List<AbstractGoods> getInputList() {
        return this.inputs == null ? EMPTY_LIST : this.inputs;
    }

    public final Stream<AbstractGoods> getInputs() {
        return this.inputs == null ? Stream.empty() : this.inputs.stream();
    }

    public final void setInputs(List<AbstractGoods> newInputs) {
        this.inputs = newInputs;
    }

    private void addInput(GoodsType type, int amount) {
        if (this.inputs == null) {
            this.inputs = new ArrayList<AbstractGoods>(1);
        }
        this.inputs.add(new AbstractGoods(type, amount));
    }

    public final List<AbstractGoods> getOutputList() {
        return this.outputs == null ? EMPTY_LIST : this.outputs;
    }

    public final Stream<AbstractGoods> getOutputs() {
        return this.outputs == null ? Stream.empty() : this.outputs.stream();
    }

    public final void setOutputs(List<AbstractGoods> newOutputs) {
        this.outputs = newOutputs;
    }

    private void addOutput(GoodsType type, int amount) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<AbstractGoods>(1);
        }
        this.outputs.add(new AbstractGoods(type, amount));
    }

    public void addOutput(AbstractGoods ag) {
        if (this.outputs == null) {
            this.outputs = new ArrayList<AbstractGoods>(1);
        }
        this.outputs.add(ag);
    }

    public AbstractGoods getOutput(GoodsType goodsType) {
        return this.outputs == null ? null : CollectionUtils.find(this.outputs, AbstractGoods.matches(goodsType));
    }

    public GoodsType getBestOutputType() {
        AbstractGoods goods;
        return this.outputs == null || (goods = CollectionUtils.maximize(this.outputs, AbstractGoods.ascendingAmountComparator)) == null ? null : goods.getType();
    }

    public static boolean canProduce(GoodsType goodsType, Collection<ProductionType> types) {
        return CollectionUtils.any(CollectionUtils.flatten(types, ProductionType::getOutputs), ag -> goodsType == ag.getType() && ag.getAmount() > 0);
    }

    public static ProductionType getBestProductionType(GoodsType goodsType, Collection<ProductionType> types) {
        Comparator<ProductionType> comp = CollectionUtils.cachingIntComparator(pt -> {
            AbstractGoods best = pt.getBestOutputFor(goodsType);
            return best == null ? Integer.MIN_VALUE : best.getAmount();
        });
        return CollectionUtils.maximize(types, comp);
    }

    private AbstractGoods getBestOutputFor(GoodsType goodsType) {
        Predicate<AbstractGoods> typePred = ag -> goodsType == null || ag.getType() == goodsType;
        return CollectionUtils.maximize(this.getOutputs(), typePred, AbstractGoods.ascendingAmountComparator);
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        ProductionType o = this.copyInCast(other, ProductionType.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        this.unattended = o.getUnattended();
        this.productionLevel = o.getProductionLevel();
        this.setOutputs(o.getOutputList());
        this.setInputs(o.getInputList());
        return true;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        if (this.unattended) {
            xw.writeAttribute(UNATTENDED_TAG, this.unattended);
        }
        if (this.productionLevel != null) {
            xw.writeAttribute(PRODUCTION_LEVEL_TAG, this.productionLevel);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.inputs != null) {
            for (AbstractGoods input : this.inputs) {
                xw.writeStartElement(INPUT_TAG);
                xw.writeAttribute(GOODS_TYPE_TAG, input.getType());
                xw.writeAttribute("value", input.getAmount());
                xw.writeEndElement();
            }
        }
        if (this.outputs != null) {
            for (AbstractGoods output : this.outputs) {
                xw.writeStartElement(OUTPUT_TAG);
                xw.writeAttribute(GOODS_TYPE_TAG, output.getType());
                xw.writeAttribute("value", output.getAmount());
                xw.writeEndElement();
            }
        }
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        this.unattended = xr.getAttribute(UNATTENDED_TAG, false);
        this.productionLevel = xr.getAttribute(PRODUCTION_LEVEL_TAG, null);
        if (this.productionLevel == null) {
            this.productionLevel = xr.getAttribute(OLD_PRODUCTION_LEVEL_TAG, null);
        }
    }

    @Override
    public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (this.inputs != null) {
            this.inputs.clear();
        }
        if (this.outputs != null) {
            this.outputs.clear();
        }
        super.readChildren(xr);
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (INPUT_TAG.equals(tag)) {
            GoodsType type = xr.getType(spec, GOODS_TYPE_TAG, GoodsType.class, null);
            if (type == null) {
                logger.warning("Skipping input with null type: " + xr.getAttribute(GOODS_TYPE_TAG, null));
            } else {
                this.addInput(type, xr.getAttribute("value", -1));
            }
            xr.closeTag(INPUT_TAG);
        } else if (OUTPUT_TAG.equals(tag)) {
            GoodsType type = xr.getType(spec, GOODS_TYPE_TAG, GoodsType.class, null);
            if (type == null) {
                logger.warning("Skipping output with null type: " + xr.getAttribute(GOODS_TYPE_TAG, null));
            } else {
                this.addOutput(type, xr.getAttribute("value", -1));
            }
            xr.closeTag(OUTPUT_TAG);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ProductionType) {
            ProductionType other = (ProductionType)o;
            return this.unattended == other.unattended && CollectionUtils.listEquals(this.outputs, other.outputs) && CollectionUtils.listEquals(this.inputs, other.inputs) && Utils.equals(this.productionLevel, other.productionLevel) && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + (this.unattended ? 1 : 0);
        hash = 31 * hash + Utils.hashCode(this.productionLevel);
        if (this.outputs != null) {
            for (AbstractGoods ag : this.outputs) {
                hash = 31 * hash + Utils.hashCode(ag);
            }
        }
        if (this.inputs != null) {
            for (AbstractGoods ag : this.inputs) {
                hash = 31 * hash + Utils.hashCode(ag);
            }
        }
        return hash;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder(64);
        result.append('[').append(this.getId()).append(':');
        if (this.productionLevel != null) {
            result.append(' ').append(this.productionLevel);
        }
        if (this.unattended) {
            result.append(" unattended");
        }
        if (this.inputs != null && !this.inputs.isEmpty()) {
            result.append(" [inputs: ");
            for (AbstractGoods input : this.inputs) {
                result.append(input).append(", ");
            }
            int length = result.length();
            result.replace(length - 2, length, "]");
        }
        if (this.outputs != null && !this.outputs.isEmpty()) {
            result.append(" [outputs: ");
            for (AbstractGoods output : this.outputs) {
                result.append(output).append(", ");
            }
            int length = result.length();
            result.replace(length - 2, length, "]");
        }
        result.append(']');
        return result.toString();
    }
}

