/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.networking;

import java.io.IOException;
import net.sf.freecol.FreeCol;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.MessageHandler;
import net.sf.freecol.common.networking.ServerAPI;

public class UserServerAPI
extends ServerAPI {
    private Connection connection = null;
    private String name = null;
    private String host = null;
    private int port = -1;
    private MessageHandler messageHandler = null;

    private synchronized String getName() {
        return this.name;
    }

    private synchronized String getHost() {
        return this.host;
    }

    private synchronized int getPort() {
        return this.port;
    }

    private synchronized void updateParameters(String name, String host, int port) {
        this.name = name;
        this.host = host;
        this.port = port;
    }

    private synchronized void updateConnection(Connection c) {
        c.setMessageHandler(this.messageHandler);
        c.setWriteScope(FreeColXMLWriter.WriteScope.toServer());
        this.connection = c;
    }

    private static Connection newConnection(String name, String host, int port) throws IOException {
        int tries;
        if (port < 0) {
            port = FreeCol.getServerPort();
            tries = 10;
        } else {
            tries = 1;
        }
        Connection conn = null;
        for (int i = tries; i > 0; --i) {
            try {
                conn = new Connection(host, port, name);
                conn.startReceiving();
                break;
            }
            catch (IOException e) {
                if (i > 1) continue;
                throw e;
            }
        }
        return conn;
    }

    @Override
    public Connection connect(String name, String host, int port) throws IOException {
        Connection c = UserServerAPI.newConnection(name, host, port);
        if (c == null) {
            return null;
        }
        this.updateConnection(c);
        this.updateParameters(name, host, port);
        return c;
    }

    @Override
    public synchronized boolean disconnect() {
        if (this.connection != null) {
            this.connection.disconnect();
            this.connection = null;
        }
        return true;
    }

    @Override
    public Connection reconnect() throws IOException {
        Connection c = UserServerAPI.newConnection(this.getName(), this.getHost(), this.getPort());
        if (c != null) {
            this.updateConnection(c);
        }
        return c;
    }

    @Override
    public synchronized Connection getConnection() {
        return this.connection;
    }

    @Override
    public synchronized void setMessageHandler(MessageHandler mh) {
        super.setMessageHandler(mh);
        this.messageHandler = mh;
    }
}

