/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.common.option.IntegerOption;

public final class IntegerOptionUI
extends OptionUI<IntegerOption> {
    private final JSpinner spinner = new JSpinner();

    public IntegerOptionUI(IntegerOption option, boolean editable) {
        super(option, editable);
        int value = option.getValue();
        int min = option.getMinimumValue();
        int max = option.getMaximumValue();
        if (min > max) {
            int tmp = min;
            min = max;
            max = tmp;
        }
        int stepSize = option.getStepSize() > 0 ? option.getStepSize() : Math.max(1, Math.min((max - min) / 10, 1000));
        this.spinner.setModel(new SpinnerNumberModel(value, min, max, stepSize));
        this.initialize();
    }

    @Override
    public JComponent getComponent() {
        return this.spinner;
    }

    @Override
    public void updateOption() {
        ((IntegerOption)this.getOption()).setValue((Integer)this.spinner.getValue());
    }

    @Override
    public void reset() {
        this.spinner.setValue(((IntegerOption)this.getOption()).getValue());
    }
}

