/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.linked.AttributeImpl;
import net.sf.saxon.tree.linked.ElementImpl;

final class AttributeAxisIterator
implements AxisIterator,
LookaheadIterator {
    private final ElementImpl element;
    private final NodeTest nodeTest;
    private NodeInfo nextNode;
    private int index;
    private final int length;

    AttributeAxisIterator(ElementImpl node, NodeTest nodeTest) {
        this.element = node;
        this.nodeTest = nodeTest;
        this.index = 0;
        this.length = node.attributes().size();
        this.advance();
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.nextNode != null;
    }

    @Override
    public NodeInfo next() {
        if (this.nextNode == null) {
            return null;
        }
        NodeInfo current = this.nextNode;
        this.advance();
        return current;
    }

    private void advance() {
        while (true) {
            if (this.index >= this.length) {
                this.nextNode = null;
                return;
            }
            AttributeInfo info = this.element.attributes().itemAt(this.index);
            if (info instanceof AttributeInfo.Deleted) {
                ++this.index;
                continue;
            }
            this.nextNode = new AttributeImpl(this.element, this.index);
            ++this.index;
            if (this.nodeTest.test(this.nextNode)) break;
        }
    }
}

