/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.loom.type;

import javax.xml.namespace.QName;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.codehaus.xfire.aegis.type.DefaultTypeMappingRegistry;
import org.codehaus.xfire.aegis.type.Type;
import org.codehaus.xfire.aegis.type.TypeMapping;
import org.codehaus.xfire.aegis.type.basic.BooleanType;
import org.codehaus.xfire.aegis.type.basic.DoubleType;
import org.codehaus.xfire.aegis.type.basic.FloatType;
import org.codehaus.xfire.aegis.type.basic.IntType;
import org.codehaus.xfire.aegis.type.basic.LongType;
import org.codehaus.xfire.util.ClassLoaderUtils;

public class TypeMappingRegistry
extends DefaultTypeMappingRegistry
implements LogEnabled,
Configurable {
    private Logger logger;

    public TypeMappingRegistry() {
        super(true);
    }

    public void configure(Configuration config) throws ConfigurationException {
        Configuration[] tmConfig = config.getChildren("typeMapping");
        for (int i = 0; i < tmConfig.length; ++i) {
            this.configureTypeMapping(tmConfig[i]);
        }
    }

    private void configureTypeMapping(Configuration configuration) throws ConfigurationException {
        String namespace = configuration.getAttribute("namespace");
        TypeMapping tm = this.getTypeMapping(namespace);
        if (null == tm) {
            String parentNamespace = configuration.getAttribute("parentNamespace", this.getDefaultTypeMapping().getEncodingStyleURI());
            tm = this.createTypeMapping(parentNamespace, false);
            this.register(namespace, tm);
            if (configuration.getAttributeAsBoolean("default", false)) {
                this.registerDefault(tm);
            }
            tm.register(Boolean.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "boolean"), new BooleanType());
            tm.register(Integer.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "int"), new IntType());
            tm.register(Double.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "double"), new DoubleType());
            tm.register(Float.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "float"), new FloatType());
            tm.register(Long.TYPE, new QName("http://www.w3.org/2001/XMLSchema", "long"), new LongType());
        }
        Configuration[] types = configuration.getChildren("type");
        for (int i = 0; i < types.length; ++i) {
            this.configureType(types[i], tm);
        }
    }

    private void configureType(Configuration configuration, TypeMapping tm) throws ConfigurationException {
        try {
            String ns = configuration.getAttribute("namespace");
            String name = configuration.getAttribute("name");
            QName qname = new QName(ns, name);
            Class clazz = ClassLoaderUtils.loadClass(configuration.getAttribute("class"), this.getClass());
            Class typeClass = ClassLoaderUtils.loadClass(configuration.getAttribute("type"), this.getClass());
            tm.register(clazz, qname, (Type)typeClass.newInstance());
            this.logger.debug("Registered " + typeClass.getName() + " for " + qname + " with class " + clazz.getName());
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not configure type at " + configuration.getLocation(), (Throwable)e);
        }
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }
}

