/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.samples.signature;

import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.keys.storage.StorageResolverSpi;
import org.apache.xml.security.keys.storage.implementations.CertsInFilesystemDirectoryResolver;
import org.apache.xml.security.samples.SampleUtils;
import org.apache.xml.security.samples.utils.resolver.OfflineResolver;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TestSignature {
    public static void main(String[] stringArray) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        String string = "data/ie/baltimore/merlin-examples/merlin-xmldsig-eighteen/";
        String string2 = "data/org/apache/xml/security/temp/key/";
        String[] stringArray2 = new String[]{string + "signature-keyname.xml", string + "signature-retrievalmethod-rawx509crt.xml", string + "signature-x509-crt-crl.xml", string + "signature-x509-crt.xml", string + "signature-x509-is.xml", string + "signature-x509-ski.xml", string + "signature-x509-sn.xml", string2 + "signature-retrievalmethod-x509data.xml"};
        int n = 0;
        int n2 = stringArray2.length;
        for (int i = n; i < n2; ++i) {
            try {
                String string3 = stringArray2[i];
                File file = new File(string3);
                System.out.println("");
                System.out.println("#########################################################");
                System.out.println("Try to verify " + file.toURL().toString());
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(new FileInputStream(string3));
                Element element = SampleUtils.createDSctx(document, "ds", "http://www.w3.org/2000/09/xmldsig#");
                Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)"//ds:Signature[1]", (Node)element);
                XMLSignature xMLSignature = new XMLSignature(element2, new File(string3).toURL().toString());
                xMLSignature.addResourceResolver((ResourceResolverSpi)new OfflineResolver());
                KeyInfo keyInfo = xMLSignature.getKeyInfo();
                keyInfo.addStorageResolver(new StorageResolver((StorageResolverSpi)new CertsInFilesystemDirectoryResolver(string + "certs")));
                if (keyInfo != null) {
                    X509Certificate x509Certificate = xMLSignature.getKeyInfo().getX509Certificate();
                    if (x509Certificate != null) {
                        System.out.println("Check: " + xMLSignature.checkSignatureValue(x509Certificate));
                        continue;
                    }
                    PublicKey publicKey = xMLSignature.getKeyInfo().getPublicKey();
                    if (publicKey != null) {
                        System.out.println("Check: " + xMLSignature.checkSignatureValue((Key)publicKey));
                        continue;
                    }
                    System.out.println("Could not find Certificate or PublicKey");
                    continue;
                }
                System.out.println("Could not find ds:KeyInfo");
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

