/* This file is part of GNU Dico.
   Copyright (C) 2008-2024 Sergey Poznyakoff

   GNU Dico is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Dico is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Dico.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef __dico_util_h
#define __dico_util_h

char *dico_full_file_name(const char *dir, const char *file);
size_t dico_string_trim(char *buf, size_t len, int (*pred)(int c));
size_t dico_trim_nl(char *buf);
size_t dico_trim_ws(char *buf);
int dico_sort(void *base, size_t nmemb, size_t size,
	      int (*comp)(const void *, const void *, void *),
	      void *closure);
void *dico_bsearch(void *key, const void *base, size_t nelem, size_t elsize,
		   int (*comp) (const void *, const void *, void *),
		   void *closure);

#endif
