/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.dex.writer.item;

import com.googlecode.d2j.dex.writer.insn.Insn;
import com.googlecode.d2j.dex.writer.insn.Label;
import com.googlecode.d2j.dex.writer.insn.PreBuildInsn;
import com.googlecode.d2j.dex.writer.io.DataOut;
import com.googlecode.d2j.dex.writer.item.BaseItem;
import com.googlecode.d2j.dex.writer.item.DebugInfoItem;
import com.googlecode.d2j.dex.writer.item.TypeIdItem;
import com.googlecode.d2j.reader.Op;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class CodeItem
extends BaseItem {
    public int registersSize;
    public int insSize;
    public int outsSize;
    public int insn_size;
    public List<TryItem> tries;
    public DebugInfoItem debugInfo;
    public List<Insn> insns;
    public List<EncodedCatchHandler> handlers;

    @Override
    public int place(int offset) {
        offset += 16 + this.insn_size * 2;
        if (this.tries != null && this.tries.size() > 0) {
            if ((this.insn_size & 1) != 0) {
                offset += 2;
            }
            offset += 8 * this.tries.size();
            if (this.handlers.size() > 0) {
                int base = offset;
                offset += CodeItem.lengthOfUleb128(this.handlers.size());
                for (EncodedCatchHandler h : this.handlers) {
                    h.handler_off = offset - base;
                    int size = h.addPairs.size();
                    offset += CodeItem.lengthOfSleb128(h.catchAll != null ? -size : size);
                    for (EncodedCatchHandler.AddrPair ap : h.addPairs) {
                        offset += CodeItem.lengthOfUleb128(ap.type.index) + CodeItem.lengthOfUleb128(ap.addr.offset);
                    }
                    if (h.catchAll == null) continue;
                    offset += CodeItem.lengthOfUleb128(h.catchAll.offset);
                }
            }
        }
        return offset;
    }

    @Override
    public void write(DataOut out) {
        out.ushort("registers_size", this.registersSize);
        out.ushort("ins_size", this.insSize);
        out.ushort("outs_size", this.outsSize);
        out.ushort("tries_size", this.tries == null ? 0 : this.tries.size());
        out.uint("debug_info_off", this.debugInfo == null ? 0 : this.debugInfo.offset);
        out.uint("insn_size", this.insn_size);
        ByteBuffer b = ByteBuffer.allocate(this.insn_size * 2).order(ByteOrder.LITTLE_ENDIAN);
        for (Insn insn : this.insns) {
            insn.write(b);
        }
        out.bytes("insn", b.array());
        if (this.tries != null && this.tries.size() > 0) {
            if ((this.insn_size & 1) != 0) {
                out.skip("padding", 2);
            }
            int lastEnd = 0;
            for (TryItem ti : this.tries) {
                if (ti.start.offset < lastEnd) {
                    System.err.println("'Out-of-order try' may throwed by libdex");
                }
                out.uint("start_addr", ti.start.offset);
                out.ushort("insn_count", ti.end.offset - ti.start.offset);
                lastEnd = ti.end.offset;
                out.ushort("handler_off", ti.handler.handler_off);
            }
            if (this.handlers.size() > 0) {
                out.uleb128("size", this.handlers.size());
                for (EncodedCatchHandler h : this.handlers) {
                    int size = h.addPairs.size();
                    out.sleb128("size", h.catchAll != null ? -size : size);
                    for (EncodedCatchHandler.AddrPair ap : h.addPairs) {
                        out.uleb128("type_idx", ap.type.index);
                        out.uleb128("addr", ap.addr.offset);
                    }
                    if (h.catchAll == null) continue;
                    out.uleb128("catch_all_addr", h.catchAll.offset);
                }
            }
        }
    }

    public void prepareTries(List<TryItem> tryItems) {
        if (tryItems.size() > 0) {
            ArrayList<TryItem> uniqTrys = new ArrayList<TryItem>();
            HashSet<TryItem> set = new HashSet<TryItem>();
            for (TryItem tryItem : tryItems) {
                if (!set.contains(tryItem)) {
                    uniqTrys.add(tryItem);
                    set.add(tryItem);
                    continue;
                }
                for (TryItem t : uniqTrys) {
                    if (!t.equals(tryItem)) continue;
                    this.mergeExceptionHandler(t.handler, tryItem.handler);
                }
            }
            set.clear();
            this.tries = uniqTrys;
            if (uniqTrys.size() > 0) {
                Collections.sort(uniqTrys, new Comparator<TryItem>(){

                    @Override
                    public int compare(TryItem o1, TryItem o2) {
                        int x = o1.start.offset - o2.start.offset;
                        if (x == 0) {
                            x = o1.end.offset - o2.end.offset;
                        }
                        return x;
                    }
                });
            }
            ArrayList<EncodedCatchHandler> uniqHanders = new ArrayList<EncodedCatchHandler>();
            HashMap<EncodedCatchHandler, EncodedCatchHandler> map = new HashMap<EncodedCatchHandler, EncodedCatchHandler>();
            for (TryItem tryItem : uniqTrys) {
                EncodedCatchHandler d = tryItem.handler;
                EncodedCatchHandler uH = (EncodedCatchHandler)map.get(d);
                if (uH != null) {
                    tryItem.handler = uH;
                    continue;
                }
                uniqHanders.add(d);
                map.put(d, d);
            }
            this.handlers = uniqHanders;
            map.clear();
        }
    }

    private void mergeExceptionHandler(EncodedCatchHandler to, EncodedCatchHandler from) {
        for (EncodedCatchHandler.AddrPair pair : from.addPairs) {
            if (to.addPairs.contains(pair)) continue;
            to.addPairs.add(pair);
        }
        if (to.catchAll == null) {
            to.catchAll = from.catchAll;
        }
    }

    public void prepareInsns(List<Insn> ops, List<Insn> tailOps) {
        int codeSize = 0;
        for (Insn insn : ops) {
            insn.offset = codeSize;
            codeSize += insn.getCodeUnitSize();
        }
        for (Insn insn : tailOps) {
            if ((codeSize & 1) != 0) {
                byte[] byArray = new byte[2];
                byArray[0] = (byte)Op.NOP.opcode;
                PreBuildInsn nop = new PreBuildInsn(byArray);
                insn.offset = codeSize;
                codeSize += ((Insn)nop).getCodeUnitSize();
                ops.add(nop);
            }
            insn.offset = codeSize;
            codeSize += insn.getCodeUnitSize();
            ops.add(insn);
        }
        tailOps.clear();
        this.insns = ops;
        this.insn_size = codeSize;
    }

    public static class EncodedCatchHandler {
        public int handler_off;
        public List<AddrPair> addPairs;
        public Label catchAll;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EncodedCatchHandler that = (EncodedCatchHandler)o;
            if (!this.addPairs.equals(that.addPairs)) {
                return false;
            }
            return !(this.catchAll != null ? !this.catchAll.equals(that.catchAll) : that.catchAll != null);
        }

        public int hashCode() {
            int result = this.addPairs.hashCode();
            result = 31 * result + (this.catchAll != null ? this.catchAll.offset : 0);
            return result;
        }

        public static class AddrPair {
            public final TypeIdItem type;
            public final Label addr;

            public AddrPair(TypeIdItem type, Label addr) {
                this.type = type;
                this.addr = addr;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                AddrPair addrPair = (AddrPair)o;
                if (this.addr.offset != addrPair.addr.offset) {
                    return false;
                }
                return this.type.equals(addrPair.type);
            }

            public int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + this.addr.offset;
                return result;
            }
        }
    }

    public static class TryItem {
        public Label start;
        public Label end;
        public EncodedCatchHandler handler;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TryItem tryItem = (TryItem)o;
            if (this.end.offset != tryItem.end.offset) {
                return false;
            }
            return this.start.offset == tryItem.start.offset;
        }

        public int hashCode() {
            int result = this.start.offset;
            result = 31 * result + this.end.offset;
            return result;
        }
    }
}

