/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.common;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.plaf.UIResource;

public class IconFactory {
    private static Icon _menuItemCheckIcon;
    private static Icon _checkBoxMenuItemIcon;
    private static Icon _radioButtonMenuItemIcon;
    private static Icon _menuArrowIcon;
    private static Icon _menuItemArrowIcon;

    public static Icon getMenuItemArrowIcon() {
        if (_menuItemArrowIcon == null) {
            _menuItemArrowIcon = new WindowsMenuItemArrowIcon();
        }
        return _menuItemArrowIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (_checkBoxMenuItemIcon == null) {
            _checkBoxMenuItemIcon = new WindowsCheckBoxMenuItemIcon();
        }
        return _checkBoxMenuItemIcon;
    }

    public static Icon getMenuItemCheckIcon() {
        if (_menuItemCheckIcon == null) {
            _menuItemCheckIcon = new WindowsMenuItemCheckIcon();
        }
        return _menuItemCheckIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (_radioButtonMenuItemIcon == null) {
            _radioButtonMenuItemIcon = new WindowsRadioButtonMenuItemIcon();
        }
        return _radioButtonMenuItemIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (_menuArrowIcon == null) {
            _menuArrowIcon = new WindowsMenuArrowIcon();
        }
        return _menuArrowIcon;
    }

    private static class WindowsMenuItemCheckIcon
    implements Icon,
    UIResource {
        private WindowsMenuItemCheckIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        public int getIconWidth() {
            return 7;
        }

        public int getIconHeight() {
            return 7;
        }
    }

    private static class WindowsCheckBoxMenuItemIcon
    implements Icon,
    UIResource {
        private WindowsCheckBoxMenuItemIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            AbstractButton b = (AbstractButton)c;
            if (b.isSelected()) {
                g.translate(x, y);
                g.drawLine(0, 2, 0, 4);
                g.drawLine(1, 3, 1, 5);
                g.drawLine(2, 4, 2, 6);
                g.drawLine(3, 3, 3, 5);
                g.drawLine(4, 2, 4, 4);
                g.drawLine(5, 1, 5, 3);
                g.drawLine(6, 0, 6, 2);
                g.translate(-x, -y);
            }
        }

        public int getIconWidth() {
            return 7;
        }

        public int getIconHeight() {
            return 7;
        }
    }

    private static class WindowsRadioButtonMenuItemIcon
    implements Icon,
    UIResource {
        private WindowsRadioButtonMenuItemIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            AbstractButton b = (AbstractButton)c;
            if (b.isSelected()) {
                g.fillRect(x + 2, y, 4, 6);
                g.fillRect(x + 1, y + 1, 6, 4);
            }
        }

        public int getIconWidth() {
            return 7;
        }

        public int getIconHeight() {
            return 7;
        }
    }

    private static class WindowsMenuArrowIcon
    implements Icon,
    UIResource {
        private WindowsMenuArrowIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.translate(x, y);
            if (c.getComponentOrientation().isLeftToRight()) {
                g.drawLine(0, 0, 0, 6);
                g.drawLine(1, 1, 1, 5);
                g.drawLine(2, 2, 2, 4);
                g.drawLine(3, 3, 3, 3);
            } else {
                g.drawLine(4, 0, 4, 6);
                g.drawLine(3, 1, 3, 5);
                g.drawLine(2, 2, 2, 4);
                g.drawLine(1, 3, 1, 3);
            }
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 8;
        }

        public int getIconHeight() {
            return 7;
        }
    }

    private static class WindowsMenuItemArrowIcon
    implements Icon,
    UIResource {
        private WindowsMenuItemArrowIcon() {
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        public int getIconWidth() {
            return 12;
        }

        public int getIconHeight() {
            return 7;
        }
    }
}

