/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.util.threads;

import com.almworks.util.threads.AWTBottleneck;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AWTBottleneckJobs<T> {
    private final Set<T> myJobs = new HashSet<T>();
    private final Runnable myRunnable = new Runnable(){

        public void run() {
            AWTBottleneckJobs.this.runJobs();
        }
    };
    private final AWTBottleneck myBottleneck;

    public AWTBottleneckJobs(long delay) {
        this.myBottleneck = new AWTBottleneck(delay, this.myRunnable);
    }

    public void addJob(T job) {
        this.addJob(job, false);
    }

    public void addJobDelayed(T job) {
        this.addJob(job, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(T job, boolean delayed) {
        Set<T> set = this.myJobs;
        synchronized (set) {
            this.myJobs.add(job);
        }
        if (delayed) {
            this.myBottleneck.requestDelayed();
        } else {
            this.myBottleneck.request();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeJob(T job) {
        Set<T> set = this.myJobs;
        synchronized (set) {
            return this.myJobs.remove(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJobs() {
        ArrayList<T> jobs;
        Set<T> set = this.myJobs;
        synchronized (set) {
            if (this.myJobs.isEmpty()) {
                return;
            }
            jobs = new ArrayList<T>(this.myJobs);
            this.myJobs.clear();
        }
        this.executeJobs(jobs);
    }

    private void executeJobs(List<T> jobs) {
        for (T job : jobs) {
            this.update(job);
        }
    }

    protected abstract void update(T var1);
}

