/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfStream;
import java.awt.color.ICC_Profile;

public class PdfICCBased
extends PdfStream {
    public PdfICCBased(ICC_Profile iCC_Profile) {
        try {
            int n = iCC_Profile.getNumComponents();
            switch (n) {
                case 1: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICEGRAY);
                    break;
                }
                case 3: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICERGB);
                    break;
                }
                case 4: {
                    this.put(PdfName.ALTERNATE, PdfName.DEVICECMYK);
                    break;
                }
                default: {
                    throw new PdfException(n + " component(s) is not supported in PDF1.4");
                }
            }
            this.put(PdfName.N, new PdfNumber(n));
            this.bytes = iCC_Profile.getData();
            this.flateCompress();
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }
}

