/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.serial;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBase;
import com.sleepycat.bind.serial.SerialInput;
import com.sleepycat.bind.serial.SerialOutput;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.util.FastInputStream;
import com.sleepycat.util.FastOutputStream;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.IOException;
import java.io.ObjectOutputStream;

public class SerialBinding
extends SerialBase
implements EntryBinding {
    private ClassCatalog classCatalog;
    private Class baseClass;

    public SerialBinding(ClassCatalog classCatalog, Class clazz) {
        if (classCatalog == null) {
            throw new NullPointerException("classCatalog must be non-null");
        }
        this.classCatalog = classCatalog;
        this.baseClass = clazz;
    }

    public final Class getBaseClass() {
        return this.baseClass;
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    @Override
    public Object entryToObject(DatabaseEntry databaseEntry) {
        int n = databaseEntry.getSize();
        byte[] byArray = SerialOutput.getStreamHeader();
        byte[] byArray2 = new byte[n + byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        System.arraycopy(databaseEntry.getData(), databaseEntry.getOffset(), byArray2, byArray.length, n);
        try {
            SerialInput serialInput = new SerialInput(new FastInputStream(byArray2, 0, byArray2.length), this.classCatalog, this.getClassLoader());
            return serialInput.readObject();
        }
        catch (IOException iOException) {
            throw new RuntimeExceptionWrapper(iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeExceptionWrapper(classNotFoundException);
        }
    }

    @Override
    public void objectToEntry(Object object, DatabaseEntry databaseEntry) {
        Object object2;
        if (this.baseClass != null && !this.baseClass.isInstance(object)) {
            throw new IllegalArgumentException("Data object class (" + object.getClass() + ") not an instance of binding's base class (" + this.baseClass + ')');
        }
        FastOutputStream fastOutputStream = this.getSerialOutput(object);
        try {
            object2 = new SerialOutput(fastOutputStream, this.classCatalog);
            ((ObjectOutputStream)object2).writeObject(object);
        }
        catch (IOException iOException) {
            throw new RuntimeExceptionWrapper(iOException);
        }
        object2 = SerialOutput.getStreamHeader();
        databaseEntry.setData(fastOutputStream.getBufferBytes(), ((Object)object2).length, fastOutputStream.getBufferLength() - ((Object)object2).length);
    }
}

