/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.rtinfo.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.maven.rtinfo.RuntimeInformation;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionConstraint;

@Component(role=RuntimeInformation.class)
public class DefaultRuntimeInformation
implements RuntimeInformation {
    @Requirement
    private Logger logger;
    private String mavenVersion;

    @Override
    public String getMavenVersion() {
        if (this.mavenVersion == null) {
            Properties props = new Properties();
            String resource2 = "META-INF/maven/org.apache.maven/maven-core/pom.properties";
            try (InputStream is2 = DefaultRuntimeInformation.class.getResourceAsStream("/" + resource2);){
                if (is2 != null) {
                    props.load(is2);
                } else {
                    this.logger.warn("Could not locate " + resource2 + " on classpath, Maven runtime information not available");
                }
            }
            catch (IOException e2) {
                String msg = "Could not parse " + resource2 + ", Maven runtime information not available";
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn(msg, e2);
                }
                this.logger.warn(msg);
            }
            String version = props.getProperty("version", "").trim();
            this.mavenVersion = !version.startsWith("${") ? version : "";
        }
        return this.mavenVersion;
    }

    @Override
    public boolean isMavenVersion(String versionRange) {
        Version current;
        VersionConstraint constraint;
        GenericVersionScheme versionScheme = new GenericVersionScheme();
        Validate.notBlank(versionRange, "versionRange can neither be null, empty nor blank", new Object[0]);
        try {
            constraint = versionScheme.parseVersionConstraint(versionRange);
        }
        catch (InvalidVersionSpecificationException e2) {
            throw new IllegalArgumentException(e2.getMessage(), e2);
        }
        try {
            String mavenVersion = this.getMavenVersion();
            Validate.validState(StringUtils.isNotEmpty(mavenVersion), "Could not determine current Maven version", new Object[0]);
            current = versionScheme.parseVersion(mavenVersion);
        }
        catch (InvalidVersionSpecificationException e3) {
            throw new IllegalStateException("Could not parse current Maven version: " + e3.getMessage(), e3);
        }
        if (constraint.getRange() == null) {
            return constraint.getVersion().compareTo(current) <= 0;
        }
        return constraint.containsVersion(current);
    }
}

