/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.MojoExecutionEvent;
import org.apache.maven.execution.MojoExecutionListener;
import org.apache.maven.execution.scope.internal.MojoExecutionScope;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.CompoundMojoExecutionListener;
import org.apache.maven.plugin.InvalidPluginDescriptorException;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.PluginDescriptorParsingException;
import org.apache.maven.plugin.PluginExecutionException;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.PluginResolutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Component(role=BuildPluginManager.class)
public class DefaultBuildPluginManager
implements BuildPluginManager {
    @Requirement
    private MavenPluginManager mavenPluginManager;
    @Requirement
    private LegacySupport legacySupport;
    @Requirement
    private MojoExecutionScope scope;
    private MojoExecutionListener mojoExecutionListener;
    @Requirement(role=MojoExecutionListener.class)
    private List<MojoExecutionListener> mojoExecutionListeners;

    public void setMojoExecutionListeners(List<MojoExecutionListener> listeners) {
        this.mojoExecutionListeners = listeners;
        this.mojoExecutionListener = new CompoundMojoExecutionListener(listeners);
    }

    @Override
    public PluginDescriptor loadPlugin(Plugin plugin, List<RemoteRepository> repositories, RepositorySystemSession session2) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, InvalidPluginDescriptorException {
        return this.mavenPluginManager.getPluginDescriptor(plugin, repositories, session2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeMojo(MavenSession session2, MojoExecution mojoExecution) throws MojoFailureException, MojoExecutionException, PluginConfigurationException, PluginManagerException {
        ClassRealm pluginRealm;
        MavenProject project2 = session2.getCurrentProject();
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        Mojo mojo = null;
        try {
            pluginRealm = this.getPluginRealm(session2, mojoDescriptor.getPluginDescriptor());
        }
        catch (PluginResolutionException e2) {
            throw new PluginExecutionException(mojoExecution, project2, e2);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(pluginRealm);
        MavenSession oldSession = this.legacySupport.getSession();
        this.scope.enter();
        try {
            this.scope.seed(MavenProject.class, project2);
            this.scope.seed(MojoExecution.class, mojoExecution);
            mojo = this.mavenPluginManager.getConfiguredMojo(Mojo.class, session2, mojoExecution);
            this.legacySupport.setSession(session2);
            try {
                MojoExecutionEvent mojoExecutionEvent = new MojoExecutionEvent(session2, project2, mojoExecution, mojo);
                this.mojoExecutionListener.beforeMojoExecution(mojoExecutionEvent);
                mojo.execute();
                this.mojoExecutionListener.afterMojoExecutionSuccess(mojoExecutionEvent);
            }
            catch (ClassCastException e3) {
                throw e3;
            }
            catch (RuntimeException e4) {
                throw new PluginExecutionException(mojoExecution, project2, e4);
            }
        }
        catch (PluginContainerException e5) {
            try {
                this.mojoExecutionListener.afterExecutionFailure(new MojoExecutionEvent(session2, project2, mojoExecution, mojo, e5));
                throw new PluginExecutionException(mojoExecution, project2, e5);
                catch (NoClassDefFoundError e6) {
                    this.mojoExecutionListener.afterExecutionFailure(new MojoExecutionEvent(session2, project2, mojoExecution, mojo, e6));
                    ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                    PrintStream ps = new PrintStream(os);
                    ps.println("A required class was missing while executing " + mojoDescriptor.getId() + ": " + e6.getMessage());
                    pluginRealm.display(ps);
                    PluginContainerException wrapper = new PluginContainerException(mojoDescriptor, pluginRealm, os.toString(), (Throwable)e6);
                    throw new PluginExecutionException(mojoExecution, project2, wrapper);
                }
                catch (LinkageError e7) {
                    this.mojoExecutionListener.afterExecutionFailure(new MojoExecutionEvent(session2, project2, mojoExecution, mojo, e7));
                    ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                    PrintStream ps = new PrintStream(os);
                    ps.println("An API incompatibility was encountered while executing " + mojoDescriptor.getId() + ": " + e7.getClass().getName() + ": " + e7.getMessage());
                    pluginRealm.display(ps);
                    PluginContainerException wrapper = new PluginContainerException(mojoDescriptor, pluginRealm, os.toString(), (Throwable)e7);
                    throw new PluginExecutionException(mojoExecution, project2, wrapper);
                }
                catch (ClassCastException e8) {
                    this.mojoExecutionListener.afterExecutionFailure(new MojoExecutionEvent(session2, project2, mojoExecution, mojo, e8));
                    ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
                    PrintStream ps = new PrintStream(os);
                    ps.println("A type incompatibility occurred while executing " + mojoDescriptor.getId() + ": " + e8.getMessage());
                    pluginRealm.display(ps);
                    throw new PluginExecutionException(mojoExecution, project2, os.toString(), (Throwable)e8);
                }
                catch (RuntimeException e9) {
                    this.mojoExecutionListener.afterExecutionFailure(new MojoExecutionEvent(session2, project2, mojoExecution, mojo, e9));
                    throw e9;
                }
            }
            catch (Throwable throwable) {
                this.mavenPluginManager.releaseMojo(mojo, mojoExecution);
                this.scope.exit();
                Thread.currentThread().setContextClassLoader(oldClassLoader);
                this.legacySupport.setSession(oldSession);
                throw throwable;
            }
        }
        this.mavenPluginManager.releaseMojo(mojo, mojoExecution);
        this.scope.exit();
        Thread.currentThread().setContextClassLoader(oldClassLoader);
        this.legacySupport.setSession(oldSession);
    }

    @Override
    public ClassRealm getPluginRealm(MavenSession session2, PluginDescriptor pluginDescriptor) throws PluginResolutionException, PluginManagerException {
        ClassRealm pluginRealm = pluginDescriptor.getClassRealm();
        if (pluginRealm != null) {
            return pluginRealm;
        }
        this.mavenPluginManager.setupPluginRealm(pluginDescriptor, session2, null, null, null);
        return pluginDescriptor.getClassRealm();
    }

    @Override
    public MojoDescriptor getMojoDescriptor(Plugin plugin, String goal, List<RemoteRepository> repositories, RepositorySystemSession session2) throws PluginNotFoundException, PluginResolutionException, PluginDescriptorParsingException, MojoNotFoundException, InvalidPluginDescriptorException {
        return this.mavenPluginManager.getMojoDescriptor(plugin, goal, repositories, session2);
    }
}

