/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xbaseinput;

import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xbaseinput.Messages;
import org.pentaho.di.trans.steps.xbaseinput.XBase;
import org.pentaho.di.trans.steps.xbaseinput.XBaseInputData;
import org.pentaho.di.trans.steps.xbaseinput.XBaseInputMeta;

public class XBaseInput
extends BaseStep
implements StepInterface {
    private XBaseInputMeta meta;
    private XBaseInputData data;

    public XBaseInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (XBaseInputMeta)smi;
        this.data = (XBaseInputData)sdi;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            if (this.meta.isAcceptingFilenames()) {
                this.data.files.getFiles().clear();
                int idx = -1;
                RowSet rowSet = this.findInputRowSet(this.meta.getAcceptingStepName());
                Object[] fileRowData = this.getRowFrom(rowSet);
                while (fileRowData != null) {
                    RowMetaInterface fileRowMeta = rowSet.getRowMeta();
                    if (idx < 0 && (idx = fileRowMeta.indexOfValue(this.meta.getAcceptingField())) < 0) {
                        this.logError(Messages.getString("XBaseInput.Log.Error.UnableToFindFilenameField", this.meta.getAcceptingField()));
                        this.setErrors(1L);
                        this.stopAll();
                        return false;
                    }
                    try {
                        String filename = fileRowMeta.getString(fileRowData, idx);
                        this.data.files.addFile(KettleVFS.getFileObject((String)filename));
                    }
                    catch (Exception e) {
                        throw new KettleException((Throwable)e);
                    }
                    fileRowData = this.getRowFrom(rowSet);
                }
                if (this.data.files.nrOfFiles() == 0) {
                    this.logBasic(Messages.getString("XBaseInput.Log.Error.NoFilesSpecified"));
                    return false;
                }
            }
            this.data.outputRowMeta = this.meta.getOutputFields(this.data.files, this.getStepname());
            this.openNextFile();
        }
        Object[] row = this.data.xbi.getRow(RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size()));
        while (row == null && this.data.fileNr < this.data.files.nrOfFiles()) {
            this.openNextFile();
            row = this.data.xbi.getRow(RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size()));
        }
        if (row == null) {
            this.setOutputDone();
            return false;
        }
        this.incrementLinesInput();
        int outputIndex = this.data.fields.size();
        if (this.meta.includeFilename()) {
            row[outputIndex++] = this.data.file_dbf.getName().getURI();
        }
        if (this.meta.isRowNrAdded()) {
            row[outputIndex++] = new Long(this.getLinesInput());
        }
        this.putRow(this.data.outputRowMeta, row);
        if (this.checkFeedback(this.getLinesInput())) {
            this.logBasic(Messages.getString("XBaseInput.Log.LineNr") + this.getLinesInput());
        }
        if (this.meta.getRowLimit() > 0 && this.getLinesInput() >= (long)this.meta.getRowLimit()) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (XBaseInputMeta)smi;
        this.data = (XBaseInputData)sdi;
        if (super.init(smi, sdi)) {
            this.data.files = this.meta.getTextFileList(this);
            this.data.fileNr = 0;
            if (this.data.files.nrOfFiles() == 0 && !this.meta.isAcceptingFilenames()) {
                this.logError(Messages.getString("XBaseInput.Log.Error.NoFilesSpecified"));
                return false;
            }
            if (this.meta.isAcceptingFilenames()) {
                try {
                    if (Const.isEmpty((String)this.meta.getAcceptingStepName()) || this.findInputRowSet(this.meta.getAcceptingStepName()) == null) {
                        this.logError(Messages.getString("XBaseInput.Log.Error.InvalidAcceptingStepName"));
                        return false;
                    }
                    if (Const.isEmpty((String)this.meta.getAcceptingField())) {
                        this.logError(Messages.getString("XBaseInput.Log.Error.InvalidAcceptingFieldName"));
                        return false;
                    }
                }
                catch (Exception e) {
                    this.log.logError(this.toString(), e.getMessage(), new Object[0]);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private void openNextFile() throws KettleException {
        if (this.data.xbi != null) {
            this.logBasic(Messages.getString("XBaseInput.Log.FinishedReadingRecords"));
            this.data.xbi.close();
        }
        this.data.file_dbf = this.data.files.getFile(this.data.fileNr);
        ++this.data.fileNr;
        try {
            this.data.xbi = new XBase(KettleVFS.getInputStream((FileObject)this.data.file_dbf));
            this.data.xbi.setDbfFile(this.data.file_dbf.getName().getURI());
            if (!Const.isEmpty((String)this.meta.getCharactersetName())) {
                this.data.xbi.getReader().setCharactersetName(this.meta.getCharactersetName());
            }
            this.data.xbi.open();
            this.logBasic(Messages.getString("XBaseInput.Log.OpenedXBaseFile") + " : [" + this.data.xbi + "]");
            this.data.fields = this.data.xbi.getFields();
            ResultFile resultFile = new ResultFile(0, this.data.file_dbf, this.getTransMeta().getName(), this.getStepname());
            resultFile.setComment(Messages.getString("XBaseInput.ResultFile.Comment"));
            this.addResultFile(resultFile);
        }
        catch (Exception e) {
            this.logError(Messages.getString("XBaseInput.Log.Error.CouldNotOpenXBaseFile1") + this.data.file_dbf + Messages.getString("XBaseInput.Log.Error.CouldNotOpenXBaseFile2") + e.getMessage());
            throw new KettleException((Throwable)e);
        }
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.closeLastFile();
        super.dispose(smi, sdi);
    }

    private void closeLastFile() {
        this.logBasic(Messages.getString("XBaseInput.Log.FinishedReadingRecords"));
        if (this.data.xbi != null) {
            this.data.xbi.close();
        }
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

