/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.springframework.core.io.AbstractResource;

public class ByteArrayResource
extends AbstractResource {
    private final byte[] byteArray;
    private final String description;
    static /* synthetic */ Class array$B;

    public ByteArrayResource(byte[] byteArray) {
        this(byteArray, "resource loaded from byte array");
    }

    public ByteArrayResource(byte[] byteArray, String description) {
        if (byteArray == null) {
            throw new IllegalArgumentException("Byte array must not be null");
        }
        this.byteArray = byteArray;
        this.description = description != null ? description : "";
    }

    public final byte[] getByteArray() {
        return this.byteArray;
    }

    public boolean exists() {
        return true;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.byteArray);
    }

    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ByteArrayResource && Arrays.equals(((ByteArrayResource)obj).byteArray, this.byteArray);
    }

    public int hashCode() {
        return (array$B == null ? (array$B = ByteArrayResource.class$("[B")) : array$B).hashCode() * 29 * this.byteArray.length;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

