/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject;

import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPObjectSnapshot;
import ca.sqlpower.util.TransactionEvent;
import java.beans.PropertyChangeEvent;

public class SPObjectSnapshotUpdateListener
implements SPListener {
    private SPObjectSnapshot<? extends SPObject> snapshot;
    private boolean setObsolete = false;
    private int transactionCount = 0;

    public SPObjectSnapshotUpdateListener(SPObjectSnapshot<? extends SPObject> snapshot) {
        this.snapshot = snapshot;
    }

    @Override
    public void childAdded(SPChildEvent e) {
        this.setObsolete = true;
        e.getChild().addSPListener(this);
    }

    @Override
    public void childRemoved(SPChildEvent e) {
        this.setObsolete = true;
        e.getChild().removeSPListener(this);
    }

    @Override
    public void transactionStarted(TransactionEvent e) {
        if (this.transactionCount == 0) {
            this.setObsolete = false;
        }
        ++this.transactionCount;
    }

    @Override
    public void transactionEnded(TransactionEvent e) {
        --this.transactionCount;
        if (this.transactionCount < 0) {
            throw new IllegalStateException("A transaction ended before it began.");
        }
        if (this.transactionCount == 0 && this.setObsolete) {
            this.snapshot.setObsolete(true);
        }
    }

    @Override
    public void transactionRollback(TransactionEvent e) {
    }

    @Override
    public void propertyChanged(PropertyChangeEvent evt) {
        this.setObsolete = true;
        if (this.transactionCount == 0) {
            this.snapshot.setObsolete(true);
        }
    }
}

