/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectVersion;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenContentPane;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.architect.swingui.action.ProgressAction;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.MonitorableImpl;
import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ExportPlaypenToPDFAction
extends ProgressAction {
    private static final Logger logger = Logger.getLogger(ExportPlaypenToPDFAction.class);
    private static final String FILE_KEY = "FILE_KEY";
    private static int OUTSIDE_PADDING = 10;
    private PlayPen playPen;

    public ExportPlaypenToPDFAction(ArchitectSwingSession session, PlayPen playPen) {
        super(session, playPen, Messages.getString("ExportPlaypenToPDFAction.name"), Messages.getString("ExportPlaypenToPDFAction.description"), (Icon)null);
    }

    public ExportPlaypenToPDFAction(ArchitectFrame frame) {
        super(frame, Messages.getString("ExportPlaypenToPDFAction.name"), Messages.getString("ExportPlaypenToPDFAction.description"), (Icon)null);
    }

    @Override
    public boolean setup(MonitorableImpl monitor, Map<String, Object> properties) {
        int response;
        monitor.setStarted(true);
        JFileChooser chooser = new JFileChooser(this.getSession().getRecentMenu().getMostRecentFile());
        chooser.addChoosableFileFilter(SPSUtils.PDF_FILE_FILTER);
        monitor.setJobSize(Integer.valueOf(this.getPlaypen().getContentPane().getChildren().size()));
        File file = null;
        do {
            if ((response = chooser.showSaveDialog(this.getPlaypen())) != 0) {
                return false;
            }
            file = chooser.getSelectedFile();
            String fileName = file.getName();
            if (fileName.endsWith(".pdf")) continue;
            file = new File(file.getPath() + ".pdf");
        } while (file.exists() && (response = JOptionPane.showConfirmDialog(null, Messages.getString("ExportPlaypenToPDFAction.fileAlreadyExists", file.getPath()), Messages.getString("ExportPlaypenToPDFAction.fileAlreadyExistsDialogTitle"), 0)) != 0);
        logger.debug((Object)("Saving to file: " + file.getName() + "(" + file.getPath() + ")"));
        properties.put(FILE_KEY, file);
        this.playPen = new PlayPen(this.getSession(), this.getPlaypen());
        this.playPen.destroy();
        return true;
    }

    @Override
    public void cleanUp(MonitorableImpl monitor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStuff(MonitorableImpl monitor, Map<String, Object> properties) {
        logger.debug((Object)("Creating PDF of playpen: " + this.getPlaypen()));
        PlayPen pp = this.playPen;
        int width = pp.getBounds().width + 2 * OUTSIDE_PADDING;
        int height = pp.getBounds().height + 2 * OUTSIDE_PADDING;
        Rectangle ppSize = new Rectangle((float)width, (float)height);
        OutputStream out = null;
        Document d = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream((File)properties.get(FILE_KEY)));
            d = new Document(ppSize);
            d.addTitle(Messages.getString("ExportPlaypenToPDFAction.PdfTitle"));
            d.addAuthor(System.getProperty("user.name"));
            d.addCreator(Messages.getString("ExportPlaypenToPDFAction.powerArchitectVersion") + (Object)((Object)ArchitectVersion.APP_FULL_VERSION));
            PdfWriter writer = PdfWriter.getInstance((Document)d, (OutputStream)out);
            d.open();
            PdfContentByte cb = writer.getDirectContent();
            Graphics2D g = cb.createGraphicsShapes((float)width, (float)height);
            g.translate(OUTSIDE_PADDING, OUTSIDE_PADDING);
            PlayPenContentPane contentPane = pp.getContentPane();
            for (int i = 0; i < contentPane.getChildren().size(); ++i) {
                PlayPenComponent ppc = contentPane.getChildren().get(i);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Painting component " + ppc));
                }
                g.translate(ppc.getLocation().x, ppc.getLocation().y);
                Font gFont = g.getFont();
                ppc.paint(g);
                g.setFont(gFont);
                g.translate(-ppc.getLocation().x, -ppc.getLocation().y);
                monitor.setProgress(i);
            }
            pp.paintComponent(g);
            g.dispose();
        }
        catch (Exception ex) {
            ASUtils.showExceptionDialog(this.getSession(), Messages.getString("ExportPlaypenToPDFAction.couldNotExportPlaypen"), ex);
        }
        finally {
            if (d != null) {
                try {
                    d.close();
                }
                catch (Exception ex) {
                    ASUtils.showExceptionDialog(this.getSession(), Messages.getString("ExportPlaypenToPDFAction.couldNotCloseDocument"), ex);
                }
            }
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    ASUtils.showExceptionDialog(this.getSession(), Messages.getString("ExportPlaypenToPDFAction.couldNotClosePdfFile"), ex);
                }
            }
        }
    }

    @Override
    public String getDialogMessage() {
        return Messages.getString("ExportPlaypenToPDFAction.creatingPdf");
    }

    @Override
    public String getButtonText() {
        return Messages.getString("ExportPlaypenToPDFAction.runInBackgroundOption");
    }
}

