/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLTable;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;

public abstract class AbstractTableTargetedAction
extends AbstractArchitectAction
implements SelectionListener {
    public AbstractTableTargetedAction(ArchitectFrame frame, String actionName, String actionDescription, String iconResourceName) {
        super(frame, actionName, actionDescription, iconResourceName);
        frame.addSelectionListener(this);
        this.setupAction(this.getPlaypen().getSelectedItems());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        try {
            DBTree dbt = this.getSession().getDBTree();
            if (evt.getActionCommand().equals("PlayPen")) {
                List<PlayPenComponent> selection = this.getPlaypen().getSelectedItems();
                if (selection.size() < 1) {
                    JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("AbstractTableTargetedAction.selectTable"));
                } else if (selection.size() > 1) {
                    JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("AbstractTableTargetedAction.multipleItemsSelected"));
                } else if (selection.get(0) instanceof TablePane) {
                    TablePane tp = (TablePane)selection.get(0);
                    this.processTablePane(tp);
                } else {
                    JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("AbstractTableTargetedAction.selectedItemNotRecognized"));
                }
            } else if (evt.getActionCommand().equals("DBTree")) {
                TreePath[] selections = dbt.getSelectionPaths();
                if (selections != null && (selections.length == 1 || selections.length == 2 && selections[0].getLastPathComponent() instanceof SQLTable && selections[1].getLastPathComponent() instanceof SQLColumn)) {
                    TreePath tp = selections[selections.length - 1];
                    SQLObject so = (SQLObject)tp.getLastPathComponent();
                    this.processSQLObject(so);
                } else {
                    JOptionPane.showMessageDialog(dbt, Messages.getString("AbstractTableTargetedAction.instructions"));
                }
            } else {
                JOptionPane.showMessageDialog(null, "InsertColumnAction: Unknown Action Command \"" + evt.getActionCommand() + "\"", "Internal Architect Error", 0);
            }
        }
        catch (SQLObjectException ex) {
            ASUtils.showExceptionDialog(this.getSession(), Messages.getString("AbstractTableTargetedAction.columnCouldNotBeInserted") + ex.getMessage(), ex);
        }
    }

    abstract void processTablePane(TablePane var1) throws SQLObjectException;

    abstract void processSQLObject(SQLObject var1) throws SQLObjectException;

    public void setupAction(List selectedItems) {
        if (selectedItems.size() == 0) {
            this.disableAction();
        } else {
            Selectable item = (Selectable)selectedItems.get(0);
            if (item instanceof TablePane) {
                this.setEnabled(true);
            }
        }
    }

    public abstract void disableAction();

    @Override
    public void itemSelected(SelectionEvent e) {
        this.setupAction(this.getPlaypen().getSelectedItems());
    }

    @Override
    public void itemDeselected(SelectionEvent e) {
        this.setupAction(this.getPlaypen().getSelectedItems());
    }
}

