# Tab completion for cargo (https://github.com/rust-lang/cargo).

## --- WRITTEN MANUALLY ---
set -l __fish_cargo_subcommands (cargo --list 2>&1 | string replace -rf '^\s+([^\s]+)\s*(.*)' '$1\t$2' | string escape)

# Append user-installed extensions (e.g. cargo-foo, invokable as `cargo foo`) to the list of subcommands (à la git)
set -la __fish_cargo_subcommands (complete -C'cargo-' | string replace -rf '^cargo-(\w+).*' '$1')

complete -c cargo -f -c cargo -n __fish_use_subcommand -a "$__fish_cargo_subcommands"
complete -c cargo -x -c cargo -n '__fish_seen_subcommand_from help' -a "$__fish_cargo_subcommands"

for x in bench b build rustc t test
    complete -c cargo -x -n "__fish_seen_subcommand_from $x" -l bench -a "(cargo bench --bench 2>&1 | string replace -rf '^\s+' '')"
    complete -c cargo -n "__fish_seen_subcommand_from $x" -l lib -d 'Only this package\'s library'
    complete -c cargo -x -n "__fish_seen_subcommand_from $x" -l test -a "(cargo test --test 2>&1 | string replace -rf '^\s+' '')"
end

for x in bench b build r run rustc t test
    complete -c cargo -x -n "__fish_seen_subcommand_from $x" -l bin -a "(cargo run --bin 2>&1 | string replace -rf '^\s+' '')"
    complete -c cargo -x -n "__fish_seen_subcommand_from $x" -l example -a "(cargo run --example 2>&1 | string replace -rf '^\s+' '')"
end

function __fish_cargo_packages
    find . -name Cargo.toml | string replace -rf '.*/([^/]+)/?Cargo.toml' '$1'
end
complete -c cargo -n '__fish_seen_subcommand_from run test build debug check' -l package \
    -xa "(__fish_cargo_packages)"

# Look up crates.io crates matching the the single argument provided to this function
function __fish_cargo_search
    if test (string length -- "$argv[1]") -le 2
        # Don't waste time searching for strings with too many results to realistically
        # provide a meaningful completion within our results limit.
        return
    end

    # This doesn't do a prefix search, so bump up the limit a tiny bit to try and
    # get enough results to show something.
    cargo search --color never --quiet --limit 20 -- $argv[1] 2>/dev/null |
        # Filter out placeholders and "... and xxx more crates"
        string match -rvi '^\.\.\.|= "0.0.0"|# .*(reserved|yanked)' |
        # Remove the version number and map the description
        string replace -rf '^([^ ]+).*# (.*)' '$1\t$2'
end

# Complete possible crate names by search the crates.io index
complete -c cargo -n '__fish_seen_subcommand_from add install' -n '__fish_is_nth_token 2' \
    -a "(__fish_cargo_search (commandline -ct))"


## --- AUTO-GENERATED WITH `cargo complete fish` ---
complete -c cargo -n __fish_use_subcommand -l explain -d 'Run `rustc --explain CODE`'
complete -c cargo -n __fish_use_subcommand -l color -d 'Coloring: auto, always, never'
complete -c cargo -n __fish_use_subcommand -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n __fish_use_subcommand -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n __fish_use_subcommand -s V -l version -d 'Print version info and exit'
complete -c cargo -n __fish_use_subcommand -l list -d 'List installed commands'
complete -c cargo -n __fish_use_subcommand -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n __fish_use_subcommand -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n __fish_use_subcommand -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n __fish_use_subcommand -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n __fish_use_subcommand -l offline -d 'Run without accessing the network'
complete -c cargo -n __fish_use_subcommand -s h -l help -d 'Prints help information'
complete -c cargo -n __fish_use_subcommand -f -a bench -d 'Execute all benchmarks of a local package'
complete -c cargo -n __fish_use_subcommand -f -a build -d 'Compile a local package and all of its dependencies'
complete -c cargo -n __fish_use_subcommand -f -a check -d 'Check a local package and all of its dependencies for errors'
complete -c cargo -n __fish_use_subcommand -f -a clean -d 'Remove artifacts that cargo has generated in the past'
complete -c cargo -n __fish_use_subcommand -f -a complete -d 'Generate completion file for a shell'
complete -c cargo -n __fish_use_subcommand -f -a doc -d 'Build a package\'s documentation'
complete -c cargo -n __fish_use_subcommand -f -a fetch -d 'Fetch dependencies of a package from the network'
complete -c cargo -n __fish_use_subcommand -f -a fix -d 'Automatically fix lint warnings reported by rustc'
complete -c cargo -n __fish_use_subcommand -f -a generate-lockfile -d 'Generate the lockfile for a package'
complete -c cargo -n __fish_use_subcommand -f -a git-checkout -d 'This subcommand has been removed'
complete -c cargo -n __fish_use_subcommand -f -a init -d 'Create a new cargo package in an existing directory'
complete -c cargo -n __fish_use_subcommand -f -a install -d 'Install a Rust binary. Default location is $HOME/.cargo/bin'
complete -c cargo -n __fish_use_subcommand -f -a locate-project -d 'Print a JSON representation of a Cargo.toml file\'s location'
complete -c cargo -n __fish_use_subcommand -f -a login -d 'Save an api token from the registry locally. If token is not specified, it will be read from stdin.'
complete -c cargo -n __fish_use_subcommand -f -a logout -d 'Remove an API token from the registry locally'
complete -c cargo -n __fish_use_subcommand -f -a metadata -d 'Output the resolved dependencies of a package, the concrete used versions including overrides, in machine-readable format'
complete -c cargo -n __fish_use_subcommand -f -a new -d 'Create a new cargo package at <path>'
complete -c cargo -n __fish_use_subcommand -f -a owner -d 'Manage the owners of a crate on the registry'
complete -c cargo -n __fish_use_subcommand -f -a package -d 'Assemble the local package into a distributable tarball'
complete -c cargo -n __fish_use_subcommand -f -a pkgid -d 'Print a fully qualified package specification'
complete -c cargo -n __fish_use_subcommand -f -a publish -d 'Upload a package to the registry'
complete -c cargo -n __fish_use_subcommand -f -a read-manifest -d 'Print a JSON representation of a Cargo.toml manifest.

Deprecated, use `cargo metadata --no-deps` instead.'
complete -c cargo -n __fish_use_subcommand -f -a run -d 'Run a binary or example of the local package'
complete -c cargo -n __fish_use_subcommand -f -a rustc -d 'Compile a package, and pass extra options to the compiler'
complete -c cargo -n __fish_use_subcommand -f -a rustdoc -d 'Build a package\'s documentation, using specified custom flags.'
complete -c cargo -n __fish_use_subcommand -f -a search -d 'Search packages in crates.io'
complete -c cargo -n __fish_use_subcommand -f -a test -d 'Execute all unit and integration tests and build examples of a local package'
complete -c cargo -n __fish_use_subcommand -f -a tree -d 'Display a tree visualization of a dependency graph'
complete -c cargo -n __fish_use_subcommand -f -a uninstall -d 'Remove a Rust binary'
complete -c cargo -n __fish_use_subcommand -f -a update -d 'Update dependencies as recorded in the local lock file'
complete -c cargo -n __fish_use_subcommand -f -a vendor -d 'Vendor all dependencies for a project locally'
complete -c cargo -n __fish_use_subcommand -f -a verify-project -d 'Check correctness of crate manifest'
complete -c cargo -n __fish_use_subcommand -f -a version -d 'Show version information'
complete -c cargo -n __fish_use_subcommand -f -a yank -d 'Remove a pushed crate from the index'
complete -c cargo -n __fish_use_subcommand -f -a help -d 'Prints this message or the help of the given subcommand(s)'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l bin -d 'Benchmark only the specified binary'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l example -d 'Benchmark only the specified example'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l test -d 'Benchmark only the specified test target'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l bench -d 'Benchmark only the specified bench target'
complete -c cargo -n "__fish_seen_subcommand_from bench" -s p -l package -d 'Package to run benchmarks for'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l exclude -d 'Exclude packages from the benchmark'
complete -c cargo -n "__fish_seen_subcommand_from bench" -s j -l jobs -d 'Number of parallel jobs, defaults to # of CPUs'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l features -d 'Space or comma separated list of features to activate'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l target -d 'Build for the target triple'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l target-dir -d 'Directory for all generated artifacts'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l message-format -d 'Error format'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from bench" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from bench" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l lib -d 'Benchmark only this package\'s library'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l bins -d 'Benchmark all binaries'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l examples -d 'Benchmark all examples'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l tests -d 'Benchmark all tests'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l benches -d 'Benchmark all benches'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l all-targets -d 'Benchmark all targets'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l no-run -d 'Compile, but don\'t run benchmarks'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l all -d 'Alias for --workspace (deprecated)'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l workspace -d 'Benchmark all packages in the workspace'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l all-features -d 'Activate all available features'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l no-default-features -d 'Do not activate the `default` feature'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l ignore-rust-version -d 'Ignore `rust-version` specification in packages (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l no-fail-fast -d 'Run all benchmarks regardless of failure'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l unit-graph -d 'Output build graph in JSON (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from bench" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from bench" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from bench" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from bench" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from build" -s p -l package -d 'Package to build (see `cargo help pkgid`)'
complete -c cargo -n "__fish_seen_subcommand_from build" -l exclude -d 'Exclude packages from the build'
complete -c cargo -n "__fish_seen_subcommand_from build" -s j -l jobs -d 'Number of parallel jobs, defaults to # of CPUs'
complete -c cargo -n "__fish_seen_subcommand_from build" -l bin -d 'Build only the specified binary'
complete -c cargo -n "__fish_seen_subcommand_from build" -l example -d 'Build only the specified example'
complete -c cargo -n "__fish_seen_subcommand_from build" -l test -d 'Build only the specified test target'
complete -c cargo -n "__fish_seen_subcommand_from build" -l bench -d 'Build only the specified bench target'
complete -c cargo -n "__fish_seen_subcommand_from build" -l profile -d 'Build artifacts with the specified profile'
complete -c cargo -n "__fish_seen_subcommand_from build" -l features -d 'Space or comma separated list of features to activate'
complete -c cargo -n "__fish_seen_subcommand_from build" -l target -d 'Build for the target triple'
complete -c cargo -n "__fish_seen_subcommand_from build" -l target-dir -d 'Directory for all generated artifacts'
complete -c cargo -n "__fish_seen_subcommand_from build" -l out-dir -d 'Copy final artifacts to this directory (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from build" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from build" -l message-format -d 'Error format'
complete -c cargo -n "__fish_seen_subcommand_from build" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from build" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from build" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from build" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from build" -l all -d 'Alias for --workspace (deprecated)'
complete -c cargo -n "__fish_seen_subcommand_from build" -l workspace -d 'Build all packages in the workspace'
complete -c cargo -n "__fish_seen_subcommand_from build" -l lib -d 'Build only this package\'s library'
complete -c cargo -n "__fish_seen_subcommand_from build" -l bins -d 'Build all binaries'
complete -c cargo -n "__fish_seen_subcommand_from build" -l examples -d 'Build all examples'
complete -c cargo -n "__fish_seen_subcommand_from build" -l tests -d 'Build all tests'
complete -c cargo -n "__fish_seen_subcommand_from build" -l benches -d 'Build all benches'
complete -c cargo -n "__fish_seen_subcommand_from build" -l all-targets -d 'Build all targets'
complete -c cargo -n "__fish_seen_subcommand_from build" -l release -d 'Build artifacts in release mode, with optimizations'
complete -c cargo -n "__fish_seen_subcommand_from build" -l all-features -d 'Activate all available features'
complete -c cargo -n "__fish_seen_subcommand_from build" -l no-default-features -d 'Do not activate the `default` feature'
complete -c cargo -n "__fish_seen_subcommand_from build" -l ignore-rust-version -d 'Ignore `rust-version` specification in packages (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from build" -l build-plan -d 'Output the build plan in JSON (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from build" -l unit-graph -d 'Output build graph in JSON (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from build" -l future-incompat-report -d 'Ouputs a future incompatibility report at the end of the build (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from build" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from build" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from build" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from build" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from build" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from build" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from check" -s p -l package -d 'Package(s) to check'
complete -c cargo -n "__fish_seen_subcommand_from check" -l exclude -d 'Exclude packages from the check'
complete -c cargo -n "__fish_seen_subcommand_from check" -s j -l jobs -d 'Number of parallel jobs, defaults to # of CPUs'
complete -c cargo -n "__fish_seen_subcommand_from check" -l bin -d 'Check only the specified binary'
complete -c cargo -n "__fish_seen_subcommand_from check" -l example -d 'Check only the specified example'
complete -c cargo -n "__fish_seen_subcommand_from check" -l test -d 'Check only the specified test target'
complete -c cargo -n "__fish_seen_subcommand_from check" -l bench -d 'Check only the specified bench target'
complete -c cargo -n "__fish_seen_subcommand_from check" -l profile -d 'Check artifacts with the specified profile'
complete -c cargo -n "__fish_seen_subcommand_from check" -l features -d 'Space or comma separated list of features to activate'
complete -c cargo -n "__fish_seen_subcommand_from check" -l target -d 'Check for the target triple'
complete -c cargo -n "__fish_seen_subcommand_from check" -l target-dir -d 'Directory for all generated artifacts'
complete -c cargo -n "__fish_seen_subcommand_from check" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from check" -l message-format -d 'Error format'
complete -c cargo -n "__fish_seen_subcommand_from check" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from check" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from check" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from check" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from check" -l all -d 'Alias for --workspace (deprecated)'
complete -c cargo -n "__fish_seen_subcommand_from check" -l workspace -d 'Check all packages in the workspace'
complete -c cargo -n "__fish_seen_subcommand_from check" -l lib -d 'Check only this package\'s library'
complete -c cargo -n "__fish_seen_subcommand_from check" -l bins -d 'Check all binaries'
complete -c cargo -n "__fish_seen_subcommand_from check" -l examples -d 'Check all examples'
complete -c cargo -n "__fish_seen_subcommand_from check" -l tests -d 'Check all tests'
complete -c cargo -n "__fish_seen_subcommand_from check" -l benches -d 'Check all benches'
complete -c cargo -n "__fish_seen_subcommand_from check" -l all-targets -d 'Check all targets'
complete -c cargo -n "__fish_seen_subcommand_from check" -l release -d 'Check artifacts in release mode, with optimizations'
complete -c cargo -n "__fish_seen_subcommand_from check" -l all-features -d 'Activate all available features'
complete -c cargo -n "__fish_seen_subcommand_from check" -l no-default-features -d 'Do not activate the `default` feature'
complete -c cargo -n "__fish_seen_subcommand_from check" -l ignore-rust-version -d 'Ignore `rust-version` specification in packages (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from check" -l unit-graph -d 'Output build graph in JSON (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from check" -l future-incompat-report -d 'Ouputs a future incompatibility report at the end of the build (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from check" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from check" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from check" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from check" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from check" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from check" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from clean" -s p -l package -d 'Package to clean artifacts for'
complete -c cargo -n "__fish_seen_subcommand_from clean" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from clean" -l target -d 'Target triple to clean output for'
complete -c cargo -n "__fish_seen_subcommand_from clean" -l target-dir -d 'Directory for all generated artifacts'
complete -c cargo -n "__fish_seen_subcommand_from clean" -l profile -d 'Clean artifacts of the specified profile'
complete -c cargo -n "__fish_seen_subcommand_from clean" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from clean" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from clean" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from clean" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from clean" -l release -d 'Whether or not to clean release artifacts'
complete -c cargo -n "__fish_seen_subcommand_from clean" -l doc -d 'Whether or not to clean just the documentation directory'
complete -c cargo -n "__fish_seen_subcommand_from clean" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from clean" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from clean" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from clean" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from clean" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from clean" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from complete" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from complete" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from complete" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from complete" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from complete" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from complete" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from complete" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from complete" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from complete" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from doc" -s p -l package -d 'Package to document'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l exclude -d 'Exclude packages from the build'
complete -c cargo -n "__fish_seen_subcommand_from doc" -s j -l jobs -d 'Number of parallel jobs, defaults to # of CPUs'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l bin -d 'Document only the specified binary'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l profile -d 'Build artifacts with the specified profile'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l features -d 'Space or comma separated list of features to activate'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l target -d 'Build for the target triple'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l target-dir -d 'Directory for all generated artifacts'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l message-format -d 'Error format'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from doc" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from doc" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l open -d 'Opens the docs in a browser after the operation'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l all -d 'Alias for --workspace (deprecated)'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l workspace -d 'Document all packages in the workspace'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l no-deps -d 'Don\'t build documentation for dependencies'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l document-private-items -d 'Document private items'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l lib -d 'Document only this package\'s library'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l bins -d 'Document all binaries'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l release -d 'Build artifacts in release mode, with optimizations'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l all-features -d 'Activate all available features'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l no-default-features -d 'Do not activate the `default` feature'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l ignore-rust-version -d 'Ignore `rust-version` specification in packages (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l unit-graph -d 'Output build graph in JSON (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from doc" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from doc" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from doc" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from doc" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from fetch" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from fetch" -l target -d 'Fetch dependencies for the target triple'
complete -c cargo -n "__fish_seen_subcommand_from fetch" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from fetch" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from fetch" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from fetch" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from fetch" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from fetch" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from fetch" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from fetch" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from fetch" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from fetch" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from fix" -s p -l package -d 'Package(s) to fix'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l exclude -d 'Exclude packages from the fixes'
complete -c cargo -n "__fish_seen_subcommand_from fix" -s j -l jobs -d 'Number of parallel jobs, defaults to # of CPUs'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l bin -d 'Fix only the specified binary'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l example -d 'Fix only the specified example'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l test -d 'Fix only the specified test target'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l bench -d 'Fix only the specified bench target'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l profile -d 'Build artifacts with the specified profile'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l features -d 'Space or comma separated list of features to activate'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l target -d 'Fix for the target triple'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l target-dir -d 'Directory for all generated artifacts'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l message-format -d 'Error format'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from fix" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from fix" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l all -d 'Alias for --workspace (deprecated)'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l workspace -d 'Fix all packages in the workspace'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l lib -d 'Fix only this package\'s library'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l bins -d 'Fix all binaries'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l examples -d 'Fix all examples'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l tests -d 'Fix all tests'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l benches -d 'Fix all benches'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l all-targets -d 'Fix all targets (default)'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l release -d 'Fix artifacts in release mode, with optimizations'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l all-features -d 'Activate all available features'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l no-default-features -d 'Do not activate the `default` feature'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l broken-code -d 'Fix code even if it already has compiler errors'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l edition -d 'Fix in preparation for the next edition'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l edition-idioms -d 'Fix warnings to migrate to the idioms of an edition'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l allow-no-vcs -d 'Fix code even if a VCS was not detected'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l allow-dirty -d 'Fix code even if the working directory is dirty'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l allow-staged -d 'Fix code even if the working directory has staged changes'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l ignore-rust-version -d 'Ignore `rust-version` specification in packages (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from fix" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from fix" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from fix" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from fix" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from generate-lockfile" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from generate-lockfile" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from generate-lockfile" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from generate-lockfile" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from generate-lockfile" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from generate-lockfile" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from generate-lockfile" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from generate-lockfile" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from generate-lockfile" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from generate-lockfile" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from generate-lockfile" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from git-checkout" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from git-checkout" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from git-checkout" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from git-checkout" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from git-checkout" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from git-checkout" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from git-checkout" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from git-checkout" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from git-checkout" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from init" -l registry -d 'Registry to use'
complete -c cargo -n "__fish_seen_subcommand_from init" -l vcs -d 'Initialize a new repository for the given version control system (git, hg, pijul, or fossil) or do not initialize any version control at all (none), overriding a global configuration.' -r -f -a "git hg pijul fossil none"
complete -c cargo -n "__fish_seen_subcommand_from init" -l edition -d 'Edition to set for the crate generated' -r -f -a "2015 2018 2021"
complete -c cargo -n "__fish_seen_subcommand_from init" -l name -d 'Set the resulting package name, defaults to the directory name'
complete -c cargo -n "__fish_seen_subcommand_from init" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from init" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from init" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from init" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from init" -l bin -d 'Use a binary (application) template [default]'
complete -c cargo -n "__fish_seen_subcommand_from init" -l lib -d 'Use a library template'
complete -c cargo -n "__fish_seen_subcommand_from init" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from init" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from init" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from init" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from init" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from init" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from install" -l version -d 'Specify a version to install'
complete -c cargo -n "__fish_seen_subcommand_from install" -l git -d 'Git URL to install the specified crate from'
complete -c cargo -n "__fish_seen_subcommand_from install" -l branch -d 'Branch to use when installing from git'
complete -c cargo -n "__fish_seen_subcommand_from install" -l tag -d 'Tag to use when installing from git'
complete -c cargo -n "__fish_seen_subcommand_from install" -l rev -d 'Specific commit to use when installing from git'
complete -c cargo -n "__fish_seen_subcommand_from install" -l path -d 'Filesystem path to local crate to install'
complete -c cargo -n "__fish_seen_subcommand_from install" -s j -l jobs -d 'Number of parallel jobs, defaults to # of CPUs'
complete -c cargo -n "__fish_seen_subcommand_from install" -l features -d 'Space or comma separated list of features to activate'
complete -c cargo -n "__fish_seen_subcommand_from install" -l profile -d 'Install artifacts with the specified profile'
complete -c cargo -n "__fish_seen_subcommand_from install" -l bin -d 'Install only the specified binary'
complete -c cargo -n "__fish_seen_subcommand_from install" -l example -d 'Install only the specified example'
complete -c cargo -n "__fish_seen_subcommand_from install" -l target -d 'Build for the target triple'
complete -c cargo -n "__fish_seen_subcommand_from install" -l target-dir -d 'Directory for all generated artifacts'
complete -c cargo -n "__fish_seen_subcommand_from install" -l root -d 'Directory to install packages into'
complete -c cargo -n "__fish_seen_subcommand_from install" -l index -d 'Registry index to install from'
complete -c cargo -n "__fish_seen_subcommand_from install" -l registry -d 'Registry to use'
complete -c cargo -n "__fish_seen_subcommand_from install" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from install" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from install" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from install" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from install" -l list -d 'list all installed packages and their versions'
complete -c cargo -n "__fish_seen_subcommand_from install" -s f -l force -d 'Force overwriting existing crates or binaries'
complete -c cargo -n "__fish_seen_subcommand_from install" -l no-track -d 'Do not save tracking information'
complete -c cargo -n "__fish_seen_subcommand_from install" -l all-features -d 'Activate all available features'
complete -c cargo -n "__fish_seen_subcommand_from install" -l no-default-features -d 'Do not activate the `default` feature'
complete -c cargo -n "__fish_seen_subcommand_from install" -l debug -d 'Build in debug mode instead of release mode'
complete -c cargo -n "__fish_seen_subcommand_from install" -l bins -d 'Install all binaries'
complete -c cargo -n "__fish_seen_subcommand_from install" -l examples -d 'Install all examples'
complete -c cargo -n "__fish_seen_subcommand_from install" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from install" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from install" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from install" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from install" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from locate-project" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from locate-project" -l message-format -d 'Output representation [possible values: json, plain]'
complete -c cargo -n "__fish_seen_subcommand_from locate-project" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from locate-project" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from locate-project" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from locate-project" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from locate-project" -l workspace -d 'Locate Cargo.toml of the workspace root'
complete -c cargo -n "__fish_seen_subcommand_from locate-project" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from locate-project" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from locate-project" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from locate-project" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from locate-project" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from locate-project" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from login" -l host -d 'Host to set the token for'
complete -c cargo -n "__fish_seen_subcommand_from login" -l registry -d 'Registry to use'
complete -c cargo -n "__fish_seen_subcommand_from login" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from login" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from login" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from login" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from login" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from login" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from login" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from login" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from login" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from login" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from logout" -l registry -d 'Registry to use'
complete -c cargo -n "__fish_seen_subcommand_from logout" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from logout" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from logout" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from logout" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from logout" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from logout" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from logout" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from logout" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from logout" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from logout" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from metadata" -l features -d 'Space or comma separated list of features to activate'
complete -c cargo -n "__fish_seen_subcommand_from metadata" -l filter-platform -d 'Only include resolve dependencies matching the given target-triple'
complete -c cargo -n "__fish_seen_subcommand_from metadata" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from metadata" -l format-version -d 'Format version' -r -f -a 1
complete -c cargo -n "__fish_seen_subcommand_from metadata" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from metadata" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from metadata" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from metadata" -s q -l quiet -d 'Do not print cargo log messages'
complete -c cargo -n "__fish_seen_subcommand_from metadata" -l all-features -d 'Activate all available features'
complete -c cargo -n "__fish_seen_subcommand_from metadata" -l no-default-features -d 'Do not activate the `default` feature'
complete -c cargo -n "__fish_seen_subcommand_from metadata" -l no-deps -d 'Output information only about the workspace members and don\'t fetch dependencies'
complete -c cargo -n "__fish_seen_subcommand_from metadata" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from metadata" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from metadata" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from metadata" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from metadata" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from metadata" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from new" -l registry -d 'Registry to use'
complete -c cargo -n "__fish_seen_subcommand_from new" -l vcs -d 'Initialize a new repository for the given version control system (git, hg, pijul, or fossil) or do not initialize any version control at all (none), overriding a global configuration.' -r -f -a "git hg pijul fossil none"
complete -c cargo -n "__fish_seen_subcommand_from new" -l edition -d 'Edition to set for the crate generated' -r -f -a "2015 2018 2021"
complete -c cargo -n "__fish_seen_subcommand_from new" -l name -d 'Set the resulting package name, defaults to the directory name'
complete -c cargo -n "__fish_seen_subcommand_from new" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from new" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from new" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from new" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from new" -l bin -d 'Use a binary (application) template [default]'
complete -c cargo -n "__fish_seen_subcommand_from new" -l lib -d 'Use a library template'
complete -c cargo -n "__fish_seen_subcommand_from new" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from new" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from new" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from new" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from new" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from new" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from owner" -s a -l add -d 'Name of a user or team to invite as an owner'
complete -c cargo -n "__fish_seen_subcommand_from owner" -s r -l remove -d 'Name of a user or team to remove as an owner'
complete -c cargo -n "__fish_seen_subcommand_from owner" -l index -d 'Registry index to modify owners for'
complete -c cargo -n "__fish_seen_subcommand_from owner" -l token -d 'API token to use when authenticating'
complete -c cargo -n "__fish_seen_subcommand_from owner" -l registry -d 'Registry to use'
complete -c cargo -n "__fish_seen_subcommand_from owner" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from owner" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from owner" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from owner" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from owner" -s l -l list -d 'List owners of a crate'
complete -c cargo -n "__fish_seen_subcommand_from owner" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from owner" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from owner" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from owner" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from owner" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from owner" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from package" -l target -d 'Build for the target triple'
complete -c cargo -n "__fish_seen_subcommand_from package" -l target-dir -d 'Directory for all generated artifacts'
complete -c cargo -n "__fish_seen_subcommand_from package" -l features -d 'Space or comma separated list of features to activate'
complete -c cargo -n "__fish_seen_subcommand_from package" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from package" -s j -l jobs -d 'Number of parallel jobs, defaults to # of CPUs'
complete -c cargo -n "__fish_seen_subcommand_from package" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from package" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from package" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from package" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from package" -s l -l list -d 'Print files included in a package without making one'
complete -c cargo -n "__fish_seen_subcommand_from package" -l no-verify -d 'Don\'t verify the contents by building them'
complete -c cargo -n "__fish_seen_subcommand_from package" -l no-metadata -d 'Ignore warnings about a lack of human-usable metadata'
complete -c cargo -n "__fish_seen_subcommand_from package" -l allow-dirty -d 'Allow dirty working directories to be packaged'
complete -c cargo -n "__fish_seen_subcommand_from package" -l all-features -d 'Activate all available features'
complete -c cargo -n "__fish_seen_subcommand_from package" -l no-default-features -d 'Do not activate the `default` feature'
complete -c cargo -n "__fish_seen_subcommand_from package" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from package" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from package" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from package" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from package" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from package" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from pkgid" -s p -l package -d 'Argument to get the package ID specifier for'
complete -c cargo -n "__fish_seen_subcommand_from pkgid" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from pkgid" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from pkgid" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from pkgid" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from pkgid" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from pkgid" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from pkgid" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from pkgid" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from pkgid" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from pkgid" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from pkgid" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l index -d 'Registry index URL to upload the package to'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l host -d 'DEPRECATED, renamed to \'--index\''
complete -c cargo -n "__fish_seen_subcommand_from publish" -l token -d 'Token to use when uploading'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l target -d 'Build for the target triple'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l target-dir -d 'Directory for all generated artifacts'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l features -d 'Space or comma separated list of features to activate'
complete -c cargo -n "__fish_seen_subcommand_from publish" -s j -l jobs -d 'Number of parallel jobs, defaults to # of CPUs'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l registry -d 'Registry to publish to'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from publish" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from publish" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l no-verify -d 'Don\'t verify the contents by building them'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l allow-dirty -d 'Allow dirty working directories to be packaged'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l all-features -d 'Activate all available features'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l no-default-features -d 'Do not activate the `default` feature'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l dry-run -d 'Perform all checks without uploading'
complete -c cargo -n "__fish_seen_subcommand_from publish" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from publish" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from publish" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from publish" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from read-manifest" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from read-manifest" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from read-manifest" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from read-manifest" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from read-manifest" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from read-manifest" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from read-manifest" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from read-manifest" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from read-manifest" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from read-manifest" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from read-manifest" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from run" -l bin -d 'Name of the bin target to run'
complete -c cargo -n "__fish_seen_subcommand_from run" -l example -d 'Name of the example target to run'
complete -c cargo -n "__fish_seen_subcommand_from run" -s p -l package -d 'Package with the target to run'
complete -c cargo -n "__fish_seen_subcommand_from run" -s j -l jobs -d 'Number of parallel jobs, defaults to # of CPUs'
complete -c cargo -n "__fish_seen_subcommand_from run" -l profile -d 'Build artifacts with the specified profile'
complete -c cargo -n "__fish_seen_subcommand_from run" -l features -d 'Space or comma separated list of features to activate'
complete -c cargo -n "__fish_seen_subcommand_from run" -l target -d 'Build for the target triple'
complete -c cargo -n "__fish_seen_subcommand_from run" -l target-dir -d 'Directory for all generated artifacts'
complete -c cargo -n "__fish_seen_subcommand_from run" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from run" -l message-format -d 'Error format'
complete -c cargo -n "__fish_seen_subcommand_from run" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from run" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from run" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from run" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from run" -l release -d 'Build artifacts in release mode, with optimizations'
complete -c cargo -n "__fish_seen_subcommand_from run" -l all-features -d 'Activate all available features'
complete -c cargo -n "__fish_seen_subcommand_from run" -l no-default-features -d 'Do not activate the `default` feature'
complete -c cargo -n "__fish_seen_subcommand_from run" -l unit-graph -d 'Output build graph in JSON (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from run" -l ignore-rust-version -d 'Ignore `rust-version` specification in packages (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from run" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from run" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from run" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from run" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from run" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from run" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -s p -l package -d 'Package to build'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -s j -l jobs -d 'Number of parallel jobs, defaults to # of CPUs'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l bin -d 'Build only the specified binary'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l example -d 'Build only the specified example'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l test -d 'Build only the specified test target'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l bench -d 'Build only the specified bench target'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l profile -d 'Build artifacts with the specified profile'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l features -d 'Space or comma separated list of features to activate'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l target -d 'Target triple which compiles will be for'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l print -d 'Output compiler information without compiling'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l target-dir -d 'Directory for all generated artifacts'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l message-format -d 'Error format'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l lib -d 'Build only this package\'s library'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l bins -d 'Build all binaries'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l examples -d 'Build all examples'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l tests -d 'Build all tests'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l benches -d 'Build all benches'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l all-targets -d 'Build all targets'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l release -d 'Build artifacts in release mode, with optimizations'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l all-features -d 'Activate all available features'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l no-default-features -d 'Do not activate the `default` feature'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l unit-graph -d 'Output build graph in JSON (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l ignore-rust-version -d 'Ignore `rust-version` specification in packages (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l future-incompat-report -d 'Ouputs a future incompatibility report at the end of the build (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from rustc" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -s p -l package -d 'Package to document'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -s j -l jobs -d 'Number of parallel jobs, defaults to # of CPUs'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l bin -d 'Build only the specified binary'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l example -d 'Build only the specified example'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l test -d 'Build only the specified test target'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l bench -d 'Build only the specified bench target'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l profile -d 'Build artifacts with the specified profile'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l features -d 'Space or comma separated list of features to activate'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l target -d 'Build for the target triple'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l target-dir -d 'Directory for all generated artifacts'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l message-format -d 'Error format'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l open -d 'Opens the docs in a browser after the operation'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l lib -d 'Build only this package\'s library'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l bins -d 'Build all binaries'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l examples -d 'Build all examples'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l tests -d 'Build all tests'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l benches -d 'Build all benches'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l all-targets -d 'Build all targets'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l release -d 'Build artifacts in release mode, with optimizations'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l all-features -d 'Activate all available features'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l no-default-features -d 'Do not activate the `default` feature'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l unit-graph -d 'Output build graph in JSON (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l ignore-rust-version -d 'Ignore `rust-version` specification in packages (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from rustdoc" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from search" -l index -d 'Registry index URL to upload the package to'
complete -c cargo -n "__fish_seen_subcommand_from search" -l host -d 'DEPRECATED, renamed to \'--index\''
complete -c cargo -n "__fish_seen_subcommand_from search" -l limit -d 'Limit the number of results (default: 10, max: 100)'
complete -c cargo -n "__fish_seen_subcommand_from search" -l registry -d 'Registry to use'
complete -c cargo -n "__fish_seen_subcommand_from search" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from search" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from search" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from search" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from search" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from search" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from search" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from search" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from search" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from search" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from test" -l bin -d 'Test only the specified binary'
complete -c cargo -n "__fish_seen_subcommand_from test" -l example -d 'Test only the specified example'
complete -c cargo -n "__fish_seen_subcommand_from test" -l test -d 'Test only the specified test target'
complete -c cargo -n "__fish_seen_subcommand_from test" -l bench -d 'Test only the specified bench target'
complete -c cargo -n "__fish_seen_subcommand_from test" -s p -l package -d 'Package to run tests for'
complete -c cargo -n "__fish_seen_subcommand_from test" -l exclude -d 'Exclude packages from the test'
complete -c cargo -n "__fish_seen_subcommand_from test" -s j -l jobs -d 'Number of parallel jobs, defaults to # of CPUs'
complete -c cargo -n "__fish_seen_subcommand_from test" -l profile -d 'Build artifacts with the specified profile'
complete -c cargo -n "__fish_seen_subcommand_from test" -l features -d 'Space or comma separated list of features to activate'
complete -c cargo -n "__fish_seen_subcommand_from test" -l target -d 'Build for the target triple'
complete -c cargo -n "__fish_seen_subcommand_from test" -l target-dir -d 'Directory for all generated artifacts'
complete -c cargo -n "__fish_seen_subcommand_from test" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from test" -l message-format -d 'Error format'
complete -c cargo -n "__fish_seen_subcommand_from test" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from test" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from test" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from test" -s q -l quiet -d 'Display one character per test instead of one line'
complete -c cargo -n "__fish_seen_subcommand_from test" -l lib -d 'Test only this package\'s library unit tests'
complete -c cargo -n "__fish_seen_subcommand_from test" -l bins -d 'Test all binaries'
complete -c cargo -n "__fish_seen_subcommand_from test" -l examples -d 'Test all examples'
complete -c cargo -n "__fish_seen_subcommand_from test" -l tests -d 'Test all tests'
complete -c cargo -n "__fish_seen_subcommand_from test" -l benches -d 'Test all benches'
complete -c cargo -n "__fish_seen_subcommand_from test" -l all-targets -d 'Test all targets'
complete -c cargo -n "__fish_seen_subcommand_from test" -l doc -d 'Test only this library\'s documentation'
complete -c cargo -n "__fish_seen_subcommand_from test" -l no-run -d 'Compile, but don\'t run tests'
complete -c cargo -n "__fish_seen_subcommand_from test" -l no-fail-fast -d 'Run all tests regardless of failure'
complete -c cargo -n "__fish_seen_subcommand_from test" -l all -d 'Alias for --workspace (deprecated)'
complete -c cargo -n "__fish_seen_subcommand_from test" -l workspace -d 'Test all packages in the workspace'
complete -c cargo -n "__fish_seen_subcommand_from test" -l release -d 'Build artifacts in release mode, with optimizations'
complete -c cargo -n "__fish_seen_subcommand_from test" -l all-features -d 'Activate all available features'
complete -c cargo -n "__fish_seen_subcommand_from test" -l no-default-features -d 'Do not activate the `default` feature'
complete -c cargo -n "__fish_seen_subcommand_from test" -l ignore-rust-version -d 'Ignore `rust-version` specification in packages (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from test" -l unit-graph -d 'Output build graph in JSON (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from test" -l future-incompat-report -d 'Ouputs a future incompatibility report at the end of the build (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from test" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from test" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from test" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from test" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from test" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from test" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from tree" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from tree" -s p -l package -d 'Package to be used as the root of the tree'
complete -c cargo -n "__fish_seen_subcommand_from tree" -l exclude -d 'Exclude specific workspace members'
complete -c cargo -n "__fish_seen_subcommand_from tree" -l features -d 'Space or comma separated list of features to activate'
complete -c cargo -n "__fish_seen_subcommand_from tree" -l target -d 'Filter dependencies matching the given target-triple (default host platform). Pass `all` to include all targets.'
complete -c cargo -n "__fish_seen_subcommand_from tree" -s e -l edges -d 'The kinds of dependencies to display (features, normal, build, dev, all, no-dev, no-build, no-normal)'
complete -c cargo -n "__fish_seen_subcommand_from tree" -s i -l invert -d 'Invert the tree direction and focus on the given package'
complete -c cargo -n "__fish_seen_subcommand_from tree" -l prefix -d 'Change the prefix (indentation) of how each entry is displayed' -r -f -a "depth indent none"
complete -c cargo -n "__fish_seen_subcommand_from tree" -l charset -d 'Character set to use in output: utf8, ascii' -r -f -a "utf8 ascii"
complete -c cargo -n "__fish_seen_subcommand_from tree" -s f -l format -d 'Format string used for printing dependencies'
complete -c cargo -n "__fish_seen_subcommand_from tree" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from tree" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from tree" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from tree" -s q -l quiet -d 'Suppress status messages'
complete -c cargo -n "__fish_seen_subcommand_from tree" -l workspace -d 'Display the tree for all packages in the workspace'
complete -c cargo -n "__fish_seen_subcommand_from tree" -s a -l all
complete -c cargo -n "__fish_seen_subcommand_from tree" -l all-targets
complete -c cargo -n "__fish_seen_subcommand_from tree" -l all-features -d 'Activate all available features'
complete -c cargo -n "__fish_seen_subcommand_from tree" -l no-default-features -d 'Do not activate the `default` feature'
complete -c cargo -n "__fish_seen_subcommand_from tree" -l no-dev-dependencies
complete -c cargo -n "__fish_seen_subcommand_from tree" -l no-indent
complete -c cargo -n "__fish_seen_subcommand_from tree" -l prefix-depth
complete -c cargo -n "__fish_seen_subcommand_from tree" -l no-dedupe -d 'Do not de-duplicate (repeats all shared dependencies)'
complete -c cargo -n "__fish_seen_subcommand_from tree" -s d -l duplicates -d 'Show only dependencies which come in multiple versions (implies -i)'
complete -c cargo -n "__fish_seen_subcommand_from tree" -s V -l version
complete -c cargo -n "__fish_seen_subcommand_from tree" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from tree" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from tree" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from tree" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from tree" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from uninstall" -s p -l package -d 'Package to uninstall'
complete -c cargo -n "__fish_seen_subcommand_from uninstall" -l bin -d 'Only uninstall the binary NAME'
complete -c cargo -n "__fish_seen_subcommand_from uninstall" -l root -d 'Directory to uninstall packages from'
complete -c cargo -n "__fish_seen_subcommand_from uninstall" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from uninstall" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from uninstall" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from uninstall" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from uninstall" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from uninstall" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from uninstall" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from uninstall" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from uninstall" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from uninstall" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from update" -s p -l package -d 'Package to update'
complete -c cargo -n "__fish_seen_subcommand_from update" -l precise -d 'Update a single dependency to exactly PRECISE when used with -p'
complete -c cargo -n "__fish_seen_subcommand_from update" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from update" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from update" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from update" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from update" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from update" -s w -l workspace -d 'Only update the workspace packages'
complete -c cargo -n "__fish_seen_subcommand_from update" -l aggressive -d 'Force updating all dependencies of SPEC as well when used with -p'
complete -c cargo -n "__fish_seen_subcommand_from update" -l dry-run -d 'Don\'t actually write the lockfile'
complete -c cargo -n "__fish_seen_subcommand_from update" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from update" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from update" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from update" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from update" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from update" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from vendor" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from vendor" -s s -l sync -d 'Additional `Cargo.toml` to sync and vendor'
complete -c cargo -n "__fish_seen_subcommand_from vendor" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from vendor" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from vendor" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from vendor" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from vendor" -l no-delete -d 'Don\'t delete older crates in the vendor directory'
complete -c cargo -n "__fish_seen_subcommand_from vendor" -l respect-source-config -d 'Respect `[source]` config in `.cargo/config`'
complete -c cargo -n "__fish_seen_subcommand_from vendor" -l versioned-dirs -d 'Always include version in subdir name'
complete -c cargo -n "__fish_seen_subcommand_from vendor" -l no-merge-sources
complete -c cargo -n "__fish_seen_subcommand_from vendor" -l relative-path
complete -c cargo -n "__fish_seen_subcommand_from vendor" -l only-git-deps
complete -c cargo -n "__fish_seen_subcommand_from vendor" -l disallow-duplicates
complete -c cargo -n "__fish_seen_subcommand_from vendor" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from vendor" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from vendor" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from vendor" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from vendor" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from vendor" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from verify-project" -l manifest-path -d 'Path to Cargo.toml'
complete -c cargo -n "__fish_seen_subcommand_from verify-project" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from verify-project" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from verify-project" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from verify-project" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from verify-project" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from verify-project" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from verify-project" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from verify-project" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from verify-project" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from verify-project" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from version" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from version" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from version" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from version" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from version" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from version" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from version" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from version" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from version" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from version" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from yank" -l vers -d 'The version to yank or un-yank'
complete -c cargo -n "__fish_seen_subcommand_from yank" -l index -d 'Registry index to yank from'
complete -c cargo -n "__fish_seen_subcommand_from yank" -l token -d 'API token to use when authenticating'
complete -c cargo -n "__fish_seen_subcommand_from yank" -l registry -d 'Registry to use'
complete -c cargo -n "__fish_seen_subcommand_from yank" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from yank" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from yank" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from yank" -s q -l quiet -d 'No output printed to stdout'
complete -c cargo -n "__fish_seen_subcommand_from yank" -l undo -d 'Undo a yank, putting a version back into the index'
complete -c cargo -n "__fish_seen_subcommand_from yank" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from yank" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from yank" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from yank" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from yank" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from yank" -l offline -d 'Run without accessing the network'
complete -c cargo -n "__fish_seen_subcommand_from help" -l color -d 'Coloring: auto, always, never'
complete -c cargo -n "__fish_seen_subcommand_from help" -l config -d 'Override a configuration value (unstable)'
complete -c cargo -n "__fish_seen_subcommand_from help" -s Z -d 'Unstable (nightly-only) flags to Cargo, see \'cargo -Z help\' for details'
complete -c cargo -n "__fish_seen_subcommand_from help" -s h -l help -d 'Prints help information'
complete -c cargo -n "__fish_seen_subcommand_from help" -s V -l version -d 'Prints version information'
complete -c cargo -n "__fish_seen_subcommand_from help" -s v -l verbose -d 'Use verbose output (-vv very verbose/build.rs output)'
complete -c cargo -n "__fish_seen_subcommand_from help" -l frozen -d 'Require Cargo.lock and cache are up to date'
complete -c cargo -n "__fish_seen_subcommand_from help" -l locked -d 'Require Cargo.lock is up to date'
complete -c cargo -n "__fish_seen_subcommand_from help" -l offline -d 'Run without accessing the network'
