/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.messages;

import com.adobe.epubcheck.messages.DefaultSeverities;
import com.adobe.epubcheck.messages.Message;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.messages.Severities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class LocalizedMessages {
    private final Locale locale;
    private final ResourceBundle bundle;
    private static final Map<String, LocalizedMessages> localizedMessages = new HashMap<String, LocalizedMessages>();
    private final Map<MessageId, Message> cachedMessages = new EnumMap<MessageId, Message>(MessageId.class);
    private final Severities defaultSeverities = new DefaultSeverities();

    public static LocalizedMessages getInstance() {
        return LocalizedMessages.getInstance(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LocalizedMessages getInstance(Locale locale) {
        String localeKey;
        LocalizedMessages instance = null;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (localizedMessages.containsKey(localeKey = locale.getLanguage())) {
            return localizedMessages.get(localeKey);
        }
        Class<LocalizedMessages> clazz = LocalizedMessages.class;
        synchronized (LocalizedMessages.class) {
            if (instance != null) return instance;
            instance = new LocalizedMessages(locale);
            localizedMessages.put(localeKey, instance);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instance;
        }
    }

    public Message getMessage(MessageId id) {
        Message message;
        if (this.cachedMessages.containsKey(id)) {
            message = this.cachedMessages.get(id);
        } else {
            message = new Message(id, this.defaultSeverities.get(id), this.getMessageAsString(id), this.getSuggestion(id));
            this.cachedMessages.put(id, message);
        }
        return message;
    }

    public LocalizedMessages(Locale locale) {
        this.locale = locale != null ? locale : Locale.getDefault();
        this.bundle = ResourceBundle.getBundle("com.adobe.epubcheck.messages.MessageBundle", this.locale, new UTF8Control());
    }

    private String getStringFromBundle(String id) {
        String result = "";
        try {
            result = this.bundle.getString(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private String getMessageAsString(MessageId id) {
        return this.getStringFromBundle(id.name());
    }

    public String getSuggestion(MessageId id) {
        return this.getStringFromBundle(id.name() + "_SUG");
    }

    public String getSuggestion(MessageId id, String key) {
        String messageKey = id.name() + "_SUG." + key;
        String messageDefaultKey = id.name() + "_SUG.default";
        return this.bundle.containsKey(messageKey) ? this.getStringFromBundle(messageKey) : (this.bundle.containsKey(messageDefaultKey) ? this.getStringFromBundle(messageDefaultKey) : this.getSuggestion(id));
    }

    public static class UTF8Control
    extends ResourceBundle.Control {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            PropertyResourceBundle bundle = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle = new PropertyResourceBundle(new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)));
                }
                finally {
                    stream.close();
                }
            }
            return bundle;
        }
    }
}

