/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.EmptySequence;

public class SingletonIterator
implements SequenceIterator,
ReversibleIterator,
LastPositionFinder,
GroundedIterator,
LookaheadIterator {
    private final Item item;
    boolean gone = false;

    protected SingletonIterator(Item value) {
        assert (value != null);
        this.item = value;
    }

    public static SequenceIterator makeIterator(Item item) {
        if (item == null) {
            return EmptyIterator.emptyIterator();
        }
        return new SingletonIterator(item);
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    @Override
    public boolean hasNext() {
        return !this.gone;
    }

    @Override
    public Item next() {
        if (this.gone) {
            return null;
        }
        this.gone = true;
        return this.item;
    }

    @Override
    public boolean supportsGetLength() {
        return true;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public boolean isActuallyGrounded() {
        return true;
    }

    @Override
    public SingletonIterator getReverseIterator() {
        return new SingletonIterator(this.item);
    }

    public Item getValue() {
        return this.item;
    }

    @Override
    public GroundedValue materialize() {
        return this.item;
    }

    @Override
    public GroundedValue getResidue() {
        if (this.gone) {
            return EmptySequence.getInstance();
        }
        return this.item;
    }
}

